% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSizeCal.R
\name{runSampleCal}
\alias{runSampleCal}
\title{Run sample size calculation for pilot data for reference dataset}
\usage{
runSampleCal(
  exprsMat,
  cellTypes,
  n_list = c(20, 40, 60, 80, 100, seq(200, 500, 100)),
  num_repeat = 20,
  level = NULL,
  cellType_tree = NULL,
  BPPARAM = BiocParallel::SerialParam(),
  subset_test = FALSE,
  num_test = NULL,
  ...
)
}
\arguments{
\item{exprsMat}{A matrix of expression matrix of pilot dataset
(log-transformed, or normalised)}

\item{cellTypes}{A vector of cell types of pilot dataset}

\item{n_list}{A vector of integer indicates the sample size to run.}

\item{num_repeat}{An integer indicates the number of run for
each sample size will be repeated.}

\item{level}{An integer indicates the accuracy rate is calculate
based on the n-th level from top of cell type tree.
If it is NULL (by default), it will be the bottom of the cell type tree.
It can not be larger than the total number of levels of the tree.}

\item{cellType_tree}{A list indicates the cell type tree (optional),
if it is NULL, the accuracy rate is calculate
based on the provided cellTypes.}

\item{BPPARAM}{A \code{BiocParallelParam} class object
from the \code{BiocParallel} package is used. Default is SerialParam().}

\item{subset_test}{A ogical input indicates whether we used a subset of data
(fixed number for each sample size)
to test instead of all remaining data. By default, it is FALSE.}

\item{num_test}{An integer indicates the size of the test data.}

\item{...}{other parameter from scClassify}
}
\value{
A matrix of accuracy matrix, where columns corresponding to different
sample sizes, rows corresponding to the number of repetation.
}
\description{
Run sample size calculation for pilot data for reference dataset
}
\examples{
data("scClassify_example")
xin_cellTypes <- scClassify_example$xin_cellTypes
exprsMat_xin_subset <- scClassify_example$exprsMat_xin_subset

exprsMat_xin_subset <- as(exprsMat_xin_subset, "dgCMatrix")
set.seed(2019)
accMat <- runSampleCal(exprsMat_xin_subset,
xin_cellTypes,
n_list = seq(20, 100, 20),
num_repeat = 5, BPPARAM = BiocParallel::SerialParam())

}
