% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{scNoiseSim}
\alias{scNoiseSim}
\title{simulation to generate scRNA-seq data with varying level of
gene detection noise versus gene count noise}
\usage{
scNoiseSim(zinb, celltype, disper, var_dropout = 1, var_count = 1, delta)
}
\arguments{
\item{zinb}{a ZINB-WaVE object representing ZINB-WaVE fit
to real data to get realistic simulation parameters}

\item{celltype}{a factor to specify the ground-truth cell types in the
original dataset that the parameter of zinb object is fit to.
Since we filter out some simulated cells due to low amount of genes detected
in that cell,
we subset the ground truth cell types correspondingly}

\item{disper}{numeric value, parameter to control the size factor
\eqn{r} in \eqn{NB(\mu, r)}.
r is varied in the set {0.5,1,5} in our simulation(as outlined in our paper)}

\item{var_dropout}{numeric value, parameter to control the noise level added
to a common embedding space for to generate gene detection matrix.
This parameter is formulated as \eqn{\sigma_\pi}
and in the paper is selected from the set {0.1, 0.5, 1, 2, 3}}

\item{var_count}{numeric value, parameter to control the noise level
added to a common embedding space to generate gene count matrix.
This parameter is formulated as \eqn{\sigma_\mu}
and and in the paper is selected from the set {0.1, 0.5, 1, 2, 3}}

\item{delta}{intercept to control the overall gene detection rate.
and in the paper is selected from the set {-2, -0.5, 1,2.5,4}}
}
\value{
GeneExpr,a count matrix with rows number of genes
and columns number of cells

celltype,a vector specify the corresponding
celltype after QC measures.
}
\description{
simulation to generate scRNA-seq data with varying level of
gene detection noise versus gene count noise
}
\examples{

## raw counts matrix with rows are genes and columns are cells
data("zinb_toy",package = "scBFA", envir = environment())
## a vector specify the ground truth of cell types provided by conquer database
data("celltype_toy",package = "scBFA",envir = environment())

scData = scNoiseSim(zinb = zinb_toy,
         celltype = celltype_toy,
         disper = 1,
         var_dropout =1,
         var_count = 1,
         delta = 1)

}
\keyword{export}
