context("Calculating Cluster function")

test_that("Calculating Cluster function from LCS results", {
    A <- matrix(c(11,17,12,10,8,9,19,15,18,13,14,7,4,6,16,2,3,1,5,20,
               17,1,8,15,5,10,2,12,9,7,3,14,11,4,6,16,20,13,19,18,
               15,8,17,12,18,14,19,11,16,20,10,13,6,3,7,9,1,2,5,4,
               15,12,16,9,19,17,10,18,11,20,8,13,2,5,7,14,1,3,4,6,
               15,10,9,6,13,19,7,18,16,17,14,4,3,1,2,20,12,5,11,8,
               1,7,4,3,2,6,8,13,5,9,12,11,16,15,17,10,19,20,14,18,
               10,5,3,9,2,11,6,13,8,1,7,4,16,14,15,12,18,17,20,19,
               10,5,1,12,8,11,7,13,6,4,3,2,18,14,15,9,17,16,20,19,
               9,6,3,10,1,12,7,13,8,2,5,4,16,14,15,11,19,17,20,18,
               12,8,1,3,2,11,4,14,9,7,10,5,16,13,15,6,18,17,20,19,
               1,6,7,9,8,13,2,15,10,5,4,11,16,20,19,3,17,18,12,14,
               13,3,6,5,7,2,4,17,9,10,8,11,20,15,18,1,16,19,12,14,
               8,4,9,10,3,13,2,12,4,1,7,11,15,17,14,6,19,18,16,20,
               12,6,11,7,5,9,4,8,2,3,13,10,15,20,14,1,18,17,16,19,
               9,7,4,5,8,3,11,1,10,6,13,12,15,16,14,2,17,19,20,18,
               14,18,12,17,11,10,19,20,13,16,15,9,8,4,7,6,1,5,2,3,
               18,19,11,17,14,9,15,20,12,16,13,10,7,1,5,8,2,6,4,3,
               9,8,4,10,3,6,1,20,2,7,5,12,11,13,15,14,17,19,18,16,
               18,14,3,16,4,17,2,20,6,8,5,19,7,10,13,1,12,15,11,9), nrow = 19, byrow = TRUE)
    scores <- c(13, 13, 12, 12, 11, 10, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 4)
    geneOne <- c(6, 12, 2, 15, 8, 10, 5, 9, 12, 12, 13, 13, 5, 9, 17, 0, 14, 14, 0, 16, 13, 8, 8, 4, 0, 15, 15, 1, 12, 14, 13, 13, 14, 16, 1, 4, 4, 12, 12)
    geneTwo <- c(7, 13, 3, 16, 9, 11, 6, 10, 17, 14, 14, 17, 7, 11, 18, 3, 17, 18, 2, 18, 18, 10, 11, 6, 1, 17, 18, 3, 18, 15, 15, 16, 16, 17, 2, 5, 7, 15, 16)
    b <- unisort(A)
    resultRow <- matrix(c(0,1,0,
                        0,1,0,
                        0,1,0,
                        0,1,0,
                        0,1,0,
                        0,1,0,
                        1,1,0,
                        1,1,1,
                        1,1,0,
                        1,1,0,
                        0,1,1,
                        1,1,0,
                        0,1,1,
                        0,1,1,
                        0,1,0,
                        0,1,0,
                        0,1,0,
                        0,1,1,
                        0,1,0), nrow = 19, byrow=TRUE)
    resultRow <- resultRow != 0
    resultCol <- matrix(c(1,1,1,0,0,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,
                        0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,
                        1,1,0,1,1,0,1,1,0,1,0,1,0,0,1,1,1,1,1,1), nrow=3, byrow=TRUE)
    resultCol <- resultCol != 0
    resultNumber <- ncol(resultRow)
    set_runibic_params(0.85, 0.5, 0.25, 100, 0, TRUE)
    L <- cluster(b,A,scores,geneOne,geneTwo, nrow(A),ncol(A))
    expect_that( L, is_a("list"))
    expect_that( L$RowxNumber, equals(resultRow))
    expect_that( L$NumberxCol, equals(resultCol))
    expect_that( L$Number, equals(resultNumber))
})
