% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotlib.R
\name{treemapPlot}
\alias{treemapPlot}
\title{treemapPlot
Plot GO terms as a treemap.}
\usage{
treemapPlot(reducedTerms, size = "score", title = "", ...)
}
\arguments{
\item{reducedTerms}{a data.frame with the reduced terms from reduceSimMatrix()}

\item{size}{what to use as point size. Can be either GO term's "size" or "score"}

\item{title}{title of the plot. Defaults to nothing}

\item{...}{other parameters sent to treemap::treemap()}
}
\value{
A list from the call to the `treemap()` function is silently returned
}
\description{
treemapPlot
Plot GO terms as a treemap.
}
\examples{
\dontrun{
go_analysis <- read.delim(system.file("extdata/example.txt", package="rrvgo"))
simMatrix <- calculateSimMatrix(go_analysis$ID, orgdb="org.Hs.eg.db", ont="BP", method="Rel")
scores <- setNames(-log10(go_analysis$qvalue), go_analysis$ID)
reducedTerms <- reduceSimMatrix(simMatrix, scores, threshold=0.7, orgdb="org.Hs.eg.db")
treemapPlot(reducedTerms)
}
}
