% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotlib.R
\name{heatmapPlot}
\alias{heatmapPlot}
\title{heatmapPlot
Plot similarity matrix as a heatmap}
\usage{
heatmapPlot(
  simMatrix,
  reducedTerms = NULL,
  annotateParent = TRUE,
  annotationLabel = "parentTerm",
  ...
)
}
\arguments{
\item{simMatrix}{a (square) similarity matrix.}

\item{reducedTerms}{a data.frame with the reduced terms from reduceSimMatrix()}

\item{annotateParent}{whether to add annotation of the parent}

\item{annotationLabel}{display "parent" ids or "parentTerm" string}

\item{...}{other parameters sent to pheatmap::pheatmap()}
}
\value{
Invisibly a pheatmap object that is a list with components
}
\description{
heatmapPlot
Plot similarity matrix as a heatmap
}
\details{
Matrix with similarity scores between terms is represented as a heatmap.
}
\examples{
go_analysis <- read.delim(system.file("extdata/example.txt", package="rrvgo"))
simMatrix <- calculateSimMatrix(go_analysis$ID, orgdb="org.Hs.eg.db", ont="BP", method="Rel")
scores <- setNames(-log10(go_analysis$qvalue), go_analysis$ID)
reducedTerms <- reduceSimMatrix(simMatrix, scores, threshold=0.7, orgdb="org.Hs.eg.db")
heatmapPlot(simMatrix, reducedTerms, annotateParent=TRUE, annotationLabel="parentTerm", fontsize=6)
}
