% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{example-datasets}
\alias{example-datasets}
\alias{exampleRprimerAlignment}
\alias{exampleRprimerProfile}
\alias{exampleRprimerOligo}
\alias{exampleRprimerAssay}
\alias{exampleRprimerMatchOligo}
\alias{exampleRprimerMatchAssay}
\title{Example datasets}
\format{
An object of class \code{DNAMultipleAlignment} with 50 rows and 7597 columns.

An object of class \code{RprimerProfile} with 7597 rows and 12 columns.

An object of class \code{RprimerOligo} with 322 rows and 26 columns.

An object of class \code{RprimerAssay} with 4883 rows and 65 columns.

An object of class \code{RprimerMatchOligo} with 10 rows and 13 columns.

An object of class \code{RprimerMatchAssay} with 5 rows and 39 columns.
}
\usage{
data("exampleRprimerAlignment")

data("exampleRprimerProfile")

data("exampleRprimerOligo")

data("exampleRprimerAssay")

data("exampleRprimerMatchOligo")

data("exampleRprimerMatchAssay")
}
\description{
The purpose of these datasets is to illustrate the functionality of
rprimer. The following datasets are provided:

\itemize{
\item \code{exampleRprimerAlignment} - a \code{Biostrings::DNAMultipleAlignment}
object (Pages et al., 2020)
containing an alignment of 50 hepatitis E virus
sequences collected from NCBI GenBank. See
"documentation_example_alignment.txt" within the inst/script folder of this
package for more details.
\item \code{exampleRprimerProfile} - an \code{RprimerProfile} object, generated
from the alignment above.
\item \code{exampleRprimerOligo} - an \code{RprimerOligo} object, generated from
the consensus profile above.
\item \code{exampleRprimerAssay} - an \code{RprimerAssay} object, generated from
the oligos above.
\item \code{exampleRprimerMatchOligo} - an \code{RprimerMatchOligo} object,
describing how well some oligos match with the sequences in
exampleRprimerAlignment.
\item \code{exampleRprimerMatchAssay} - an \code{RprimerMatchAssay} object,
describing how well some assays match with the seuqences in
exampleRprimerAlignment.
}
}
\references{
H. Pages, P. Aboyoun, R. Gentleman and S. DebRoy (2020). Biostrings:
Efficient manipulation of biological strings. R package version
2.57.2.
}
\keyword{datasets}
