% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/helpers.R
\name{view}
\alias{view}
\alias{view,SummarizedExperiment-method}
\alias{view,ExpressionSet-method}
\alias{view,data.frame-method}
\alias{view,matrix-method}
\alias{strF}
\alias{imageF}
\title{view}
\usage{
view(
  x,
  printL = TRUE,
  plotL = TRUE,
  mainC = "",
  subC = "",
  paletteC = c("heat", "revHeat", "grey", "revGrey", "palette", "ramp")[1],
  rowAllL = FALSE,
  rowCexN = 1,
  rowMarN = 5.1,
  rowLabC = "",
  rowTruncI = 0,
  colAllL = FALSE,
  colCexN = 1,
  colMarN = 3.1,
  colLabC = "",
  colTruncI = 0,
  drawScaleL = TRUE,
  delimitReplicatesL = FALSE,
  standardizeL = FALSE,
  fig.pdfC = "interactive"
)

\S4method{view}{SummarizedExperiment}(
  x,
  printL = TRUE,
  plotL = TRUE,
  mainC = "",
  paletteC = c("heat", "revHeat", "grey", "revGrey", "palette", "ramp")[1],
  rowAllL = FALSE,
  rowCexN = 1,
  rowMarN = 5.1,
  rowLabC = "",
  rowTruncI = 0,
  colAllL = FALSE,
  colCexN = 1,
  colMarN = 3.1,
  colLabC = "",
  colTruncI = 0,
  drawScaleL = TRUE,
  delimitReplicatesL = FALSE,
  standardizeL = FALSE,
  fig.pdfC = "interactive"
)

\S4method{view}{ExpressionSet}(
  x,
  printL = TRUE,
  plotL = TRUE,
  mainC = "",
  paletteC = c("heat", "revHeat", "grey", "revGrey", "palette", "ramp")[1],
  rowAllL = FALSE,
  rowCexN = 1,
  rowMarN = 5.1,
  rowLabC = "",
  rowTruncI = 0,
  colAllL = FALSE,
  colCexN = 1,
  colMarN = 3.1,
  colLabC = "",
  colTruncI = 0,
  drawScaleL = TRUE,
  delimitReplicatesL = FALSE,
  standardizeL = FALSE,
  fig.pdfC = "interactive"
)

\S4method{view}{data.frame}(
  x,
  printL = TRUE,
  plotL = TRUE,
  mainC = "",
  subC = "",
  paletteC = c("heat", "revHeat", "grey", "revGrey", "palette", "ramp")[1],
  rowAllL = FALSE,
  rowCexN = 1,
  rowMarN = 5.1,
  rowLabC = "",
  rowTruncI = 0,
  colAllL = FALSE,
  colCexN = 1,
  colMarN = 3.1,
  colLabC = "",
  colTruncI = 0,
  drawScaleL = TRUE,
  delimitReplicatesL = FALSE,
  standardizeL = FALSE,
  fig.pdfC = "interactive"
)

\S4method{view}{matrix}(
  x,
  printL = TRUE,
  plotL = TRUE,
  mainC = "",
  subC = "",
  paletteC = c("heat", "revHeat", "grey", "revGrey", "palette", "ramp")[1],
  rowAllL = FALSE,
  rowCexN = 1,
  rowMarN = 5.1,
  rowLabC = "",
  rowTruncI = 0,
  colAllL = FALSE,
  colCexN = 1,
  colMarN = 3.1,
  colLabC = "",
  colTruncI = 0,
  drawScaleL = TRUE,
  delimitReplicatesL = FALSE,
  standardizeL = FALSE,
  fig.pdfC = "interactive"
)

strF(tableMF, borderI = 2, bigMarkC = ",")

imageF(
  x,
  mainC = "",
  subC = "",
  paletteC = c("heat", "revHeat", "grey", "revGrey", "palette", "ramp")[1],
  rowAllL = FALSE,
  rowCexN = 1,
  rowMarN = 5.1,
  rowLabC = "",
  rowTruncI = 0,
  colAllL = FALSE,
  colCexN = 1,
  colMarN = 1.1,
  colLabC = "",
  colTruncI = 0,
  drawScaleL = TRUE,
  delimitReplicatesL = FALSE,
  standardizeL = FALSE,
  fig.pdfC = "interactive"
)
}
\arguments{
\item{x}{object to be viewed}

\item{printL}{should the numerical summary be printed?}

\item{plotL}{should the graphical image be displayed?}

\item{mainC}{character: plot main title}

\item{subC}{character(1): plot subtitle}

\item{paletteC}{character: color palette; either 'heat' [default], 'revHeat', 'grey', 'revGrey', 'palette', 'ramp'}

\item{rowAllL}{logical: should all rownames be displayed or only the first and
last ones?}

\item{rowCexN}{numeric: size of row labels [default: 1]}

\item{rowMarN}{numeric: row margin [default: 5.1]}

\item{rowLabC}{character: label for the y (row) axis}

\item{rowTruncI}{integer: number of character for truncation of rownames (default,
0, means no truncation)}

\item{colAllL}{logical: should all column names be displayed or only the first and
last ones?}

\item{colCexN}{numeric: size of column labels [default: 1]}

\item{colMarN}{numeric: column margin [default: 3.1]}

\item{colLabC}{character: label for the x (column) axis}

\item{colTruncI}{integer: number of character for truncation of colnames (default,
0, means no truncation)}

\item{drawScaleL}{logical: should the color scale be drawn? [default: TRUE]}

\item{delimitReplicatesL}{logical: should lines be added to the image to delimit
replicates in row or column names?}

\item{standardizeL}{Logical: should columns be standardized for display? 
(i.e. subtracting the mean and dividing by the standard deviation) [default: FALSE]}

\item{fig.pdfC}{character: either 'interactive' [default] or the name of the pdf file to save the figure}

\item{tableMF}{Input matrix, dataframe or vector}

\item{borderI}{Number of border (first and last) rows and columns to display}

\item{bigMarkC}{Big mark separator for summary results}
}
\value{
this method has no output

This function has no output.
}
\description{
Numeric and graphical display of a matrix, a dataframe, an ExpressionSet or a SummarizedExperiment

Display of the class, mode, size and first...last values from the object; used
inside the 'view' wrapper method

Wrapper of the stats::image function used inside the 'view' method
}
\examples{
library(ropls)

# Get the sacurine dataset

data(sacurine)

# Display the data matrix

view(sacurine[["dataMatrix"]])
view(sacurine[["dataMatrix"]][, 1:40], mainC = "'Sacurine' dataset", rowAllL = TRUE,
colAllL = TRUE, colTruncI = 13, colMarN = 7)
view(sacurine[["dataMatrix"]][, 1:40], mainC = "'Sacurine' dataset", paletteC = "ramp")

# Display the sample metadata (dataframe)

view(sacurine[["sampleMetadata"]])

# Display the SummarizedExperiment

view(sacurine[["se"]])

# Display the ExpressionSet

view(sacurine[["eset"]])


data(sacurine)
strF(sacurine[['dataMatrix']])
strF(sacurine[['sampleMetadata']])


data(sacurine)
imageF(sacurine[['dataMatrix']])

}
\seealso{
\code{\link{str}}, \code{\link{view}}

\code{\link{image}}, \code{\link{view}}
}
