% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/helpers.R
\name{toW4M}
\alias{toW4M}
\alias{toW4M,ExpressionSet-method}
\title{Exporting a SummarizedExperiment or ExpressionSet instance into 3 tabulated files.}
\usage{
toW4M(x, filePrefixC = paste0(getwd(), "/out_"), verboseL = TRUE)

\S4method{toW4M}{ExpressionSet}(x, filePrefixC = paste0(getwd(), "/out_"), verboseL = TRUE)
}
\arguments{
\item{x}{An S4 object of class \code{SummarizedExperiment} or \code{ExpressionSet}
function.}

\item{filePrefixC}{Character: common prefix (including repository full path)
of the three file names: for example, the 'c:/mydata/setname' value will
result in writting the 'c:/mydata/setname_dataMatrix.tsv',
'c:/mydata/setname_sampleMetadata.tsv', and
'c:/mydata/setname_variableMetadata.tsv' files.}

\item{verboseL}{Logical: should comments be printed?}
}
\value{
No object returned.
}
\description{
The 3 .tsv files are written with the indicated \code{file} prefix, and
'_dataMatrix.tsv', '_sampleMetadata.tsv', and '_variableMetadata.tsv'
suffices, respectively. Note that the \code{dataMatrix} is transposed before
export (e.g., the samples are written column wise in the 'dataMatrix.tsv'
exported file).
}
\examples{
 sacSet <- fromW4M(file.path(path.package("ropls"), "extdata"))
 toW4M(sacSet)
}
\author{
Etienne Thevenot, \email{etienne.thevenot@cea.fr}
}
