% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Properties.R
\name{olsProperties}
\alias{olsProperties}
\alias{olsProperty}
\alias{olsProperties,character}
\alias{olsProperties,olsOntology}
\alias{olsProperties,olsTerm}
\alias{olsProperties,olsTerms}
\alias{olsProperties,length}
\alias{olsProperties,olsOntology-method}
\alias{olsProperties,character-method}
\alias{olsProperties,olsTerm-method}
\alias{olsProperties,olsTerms-method}
\alias{show,olsProperty-method}
\alias{show,olsProperties-method}
\alias{length,olsProperties-method}
\title{Term Properties}
\usage{
\S4method{olsProperties}{olsOntology}(object)

\S4method{olsProperties}{character}(object)

\S4method{olsProperties}{olsTerm}(object)

\S4method{olsProperties}{olsTerms}(object)

\S4method{show}{olsProperty}(object)

\S4method{show}{olsProperties}(object)

\S4method{length}{olsProperties}(x)
}
\arguments{
\item{object}{First input object.}

\item{x}{A `olsProperties` object.}
}
\description{
Properties (relationships) between terms can be queries for
complete [olsOntology()] objects and [olsTerm()]/[olsTerms()]
instances, and the results are stored as objects of class
`olsProperty` or `olsProperties`.
}
\examples{

## Term properties
trm <- olsTerm("uberon", "UBERON:0002107")
trm
olsProperties(trm)

## Ontology properties
olsProperties('ado')
}
\references{
- OLS3 API (the OLS4 API should function identically to the OLS3):
  <http://www.ebi.ac.uk/ols4/ols3help>

- REST API for OLS: <https://www.ebi.ac.uk/ols4/swagger-ui/index.html>
}
