% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog_queries.R
\name{catalog_queries}
\alias{catalog_queries}
\alias{gene_variants}
\alias{variant_genes}
\alias{gene_elements}
\alias{elements}
\alias{element_genes}
\title{Query the IGVF Catalog via REST API}
\usage{
gene_variants(
  gene_id = NULL,
  hgnc = NULL,
  gene_name = NULL,
  alias = NULL,
  organism = "Homo sapiens",
  log10pvalue = NULL,
  effect_size = NULL,
  page = 0L,
  limit = 25L,
  verbose = FALSE
)

variant_genes(
  spdi = NULL,
  hgvs = NULL,
  rsid = NULL,
  variant_id = NULL,
  chr = NULL,
  position = NULL,
  organism = "Homo sapiens",
  log10pvalue = NULL,
  effect_size = NULL,
  page = 0L,
  limit = 25L,
  verbose = FALSE
)

gene_elements(gene_id = NULL, page = 0L, limit = 25L, verbose = FALSE)

elements(range = NULL, page = 0L, limit = 25L)

element_genes(range = NULL, page = 0L, limit = 25L, verbose = FALSE)
}
\arguments{
\item{gene_id}{character(1) Ensembl gene identifier, e.g., "ENSG00000106633"}

\item{hgnc}{character(1) HGNC identifier}

\item{gene_name}{character(1) Gene symbol, e.g., "GCK"}

\item{alias}{character(1) Gene alias}

\item{organism}{character(1) Either 'Homo sapiens' (default) or
'Mus musculus'}

\item{log10pvalue}{character(1) The following can be used to set thresholds
on the negative log10pvalue: gt (>), gte (>=), lt (<), lte (<=), with a ":"
following and a value, e.g., "gt:5.0"}

\item{effect_size}{character(1) Optional string used for thresholding on
the effect size of the variant on the gene. See 'log10pvalue'. E.g., "gt:0.5"}

\item{page}{integer(1) when there are more response items than \code{limit}, offers pagination.
starts on page 0L, next is 1L, ...}

\item{limit}{integer(1) the limit parameter controls the page size and can not exceed 1000}

\item{verbose}{logical(1) return additional information about
variants and genes}

\item{spdi}{character(1) SPDI of variant}

\item{hgvs}{character(1) HGVS of variant}

\item{rsid}{character(1) RSID of variant}

\item{variant_id}{character(1) IGVF variant ID}

\item{chr}{character(1) UCSC-style chromosome name of variant, e.g. "chr1"}

\item{position}{character(1) 0-based position of variant}

\item{range}{the query GRanges (expects 1-based start position)}
}
\value{
\code{gene_variants()} returns a tibble describing variants
associated with the gene; use \code{verbose = TRUE} to retrieve more
extensive information.

\code{variant_genes()} returns a tibble describing genes
associated with a variant; use \code{verbose = TRUE} to retrieve more
extensive information.

\code{gene_elements()} returns a tibble describing elements
associated with the gene; use \code{verbose = TRUE} to retrieve more
extensive information.

\code{elements()} returns a GRanges object describing elements.

\code{element_genes()} returns a tibble describing genomic element and gene pairs.
}
\description{
This page documents functions using the IGVF REST
API, documented at \url{https://api.catalogkg.igvf.org/#}.

Note that functions will only return a limited number
of responses, see \code{limit} and \code{page} arguments below for control
over number of responses.

\code{gene_variants()} locates variants associated with a gene.
Only one of \code{gene_id}, \code{hgnc}, \code{gene_name}, or \code{alias}
should be specified.

\code{variant_genes()} locates genes
associated with a variant.
Only one of \code{spdi}, \code{hgvs}, \code{rsid}, \code{variant_id},
or \code{chr + position} should be specified.

\code{gene_elements()} locates elements
associated with a gene.

\code{elements()} locates genomic elements
based on a genomic range query.

\code{element_genes()} locates genomic elements and associated genes
based on a genomic range query.
}
\examples{

rigvf::gene_variants(gene_name = "GCK")

rigvf::gene_variants(gene_name = "GCK", effect_size="gt:0.5")

rigvf::gene_variants(gene_name = "GCK", verbose = TRUE)

rigvf::variant_genes(spdi = "NC_000001.11:920568:G:A")

rigvf::gene_elements(gene_id = "ENSG00000187961")

rng <- GenomicRanges::GRanges("chr1", IRanges::IRanges(1157520,1158189))

rigvf::elements(range = rng)

rigvf::element_genes(range = rng)

}
