% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_pen.r
\name{make_pen}
\alias{make_pen}
\title{\subsection{=========================================================================
make_pen}{

make_pen assigns automatically a penalties
}}
\usage{
make_pen(
  inp,
  FUN,
  cores = 1,
  logs,
  dpt = 1,
  smpl_min = 10,
  smpl_max = 100,
  sta_pen = 0.5,
  end_pen = 4.5,
  rez_pen = 9,
  sta_pen_out = 0.5,
  end_pen_out = 3.5,
  rez_pen_out = 7
)
}
\arguments{
\item{inp}{SummarizedExperiment: the input data frame with correct format.}

\item{FUN}{function: one of the four bottom level functions (see details)}

\item{cores}{integer: the number of assigned cores for the task}

\item{logs}{numeric vector: the logbook vector.}

\item{dpt}{integer: the number of times a full iteration cycle is repeated
with a more narrow range based on the previous cycle. Default is 2.}

\item{smpl_min}{integer: the smaller end of the sampling size. Default is 10.}

\item{smpl_max}{integer: the larger end of the sampling size. Default is 100.}

\item{sta_pen}{numeric: the lower starting penalty. Default is 0.5.}

\item{end_pen}{numeric: the higher starting penalty. Default is 4.5.}

\item{rez_pen}{numeric: the number of penalties iterated within the penalty
range. Default is 9.}

\item{sta_pen_out}{numeric: the lower starting outlier penalty.
Default is 0.5.}

\item{end_pen_out}{numeric: the higher starting outlier penalty.
Default is 3.5.}

\item{rez_pen_out}{numeric: the number of outlier penalties iterated within
the outlier penalty range. Default is 7.}
}
\value{
A list with 4 items:
\describe{
\item{logbook:}{Interger, the logbook vector containing all penalty information}
\item{penalties:}{Integer, a vetor with the respective penalty and outlier
penalty}
\item{correct:}{Matrix, a matrix of the correct splits}
\item{wrong:}{Matrix, a matrix of the incorrect splits}
}
}
\description{
'make_pen' calls one of four available penalty functions to automatically
assign penalties for the dynamic programming.
}
\details{
The four functions to be called are:
\enumerate{
\item fragment_delay_pen
\item fragment_HL_pen
\item fragment_inty_pen
\item fragment_TI_pen
}

These functions return the amount of statistically correct and statistically
wrong splits at a specific pair of penalties.
'make_pen' iterates over many penalty pairs and picks the most suitable pair
based on the difference between wrong and correct splits.
The sample size, penalty range and resolution as well as the number of cycles
can be customized.
The primary start parameters create a matrix with n = rez_pen rows and
n = rez_pen_out columns with values between sta_pen/sta_pen_out
and end_pen/end_pen_out. The best penalty pair is picked.
If dept is bigger than 1 the same process is repeated with a new matrix
of the same size based on the result of the previous cycle. Only position
segments with length within the sample size range are considered for the
penalties to increase run time.
Returns a penalty object (list of 4 objects) the first being the logbook.
}
\examples{
data(fit_minimal)
make_pen(
  inp = fit_minimal, FUN = rifi:::fragment_HL_pen, cores = 2,
  logs = as.numeric(rep(NA, 8)), dpt = 1, smpl_min = 10, smpl_max = 50,
  sta_pen = 0.5, end_pen = 4.5, rez_pen = 9, sta_pen_out = 0.5,
  end_pen_out = 3.5, rez_pen_out = 7
)

}
