% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{standardize}
\alias{standardize}
\title{#' Summary of an ExposomeSet.
#'
#' Given an \link{ExposomeSet} is shows a summary for its exposures or
#' its phenotypes.
#'
#' @name Summary
#' @rdname Summary-methods
#' @aliases Summary
#' @param object code{ExposomeSet} with 'set' will be summarized.
#' @param set Set to be sumarized (\code{"exposures"} or \code{"phenotypes"}).
#' @param select Subseting of exposures of phenotypes.
#' @return A basic description of the exposures in the \code{ExposomeSet}
#' @examples
#' data("exposome")
#' Summary(expo, set = "exposures")
#' @export Summary
setGeneric("Summary", function(object, set=c("exposures", "phenotypes"),
                               select)
    standardGeneric("Summary")
)
Standardize of an ExposomeSet.}
\usage{
standardize(object, select, method = "normal", na.rm = TRUE, warnings = TRUE)
}
\arguments{
\item{object}{\code{ExposomeSet} with exposures to be standardized.}

\item{select}{Subseting of exposures of phenotypes.}

\item{method}{(default \code{"normal"}) Character selecting the method to be
applied (\code{"normal"}
\code{"iqr"} or \code{"robust"}).}

\item{na.rm}{(by default \code{TRUE}) Removes NA data to perform
standardization.}

\item{warnings}{(defaulr \code{TRUE}) If set to \code{FALSE} warnings are
not shown.}
}
\value{
An \code{ExposomeSet} with the selected exposures standardized and
keeping the others exposures as the original input object.
}
\description{
Given an \link{ExposomeSet} it standardizes the exposures by using mean/sd
if method is \code{"normal"} or by using median/mad if method is
\code{"robust"}.
}
\examples{
data("exposome")
exp.sn <- standardize(expo, method = "normal", select = "lbde100_lip")
exp.rs <- standardize(expo, method = "iqr", select = "lbde100_lip")
exp.rs <- standardize(expo, method = "robust", select = "lbde100_lip")
}
\seealso{
\link{highAndLow} to transform the continuous exposures to
levelled factors, \link{trans} to transform the exposures
}
