% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{clustering}
\alias{clustering}
\title{Method to perform clustering on the samples of an ExposomeSet}
\usage{
clustering(object, method, cmethod, ..., warnings = TRUE)
}
\arguments{
\item{object}{\code{ExposomeSet} containing the exposures used for the
clustering process}

\item{method}{Function applied to the exposures of \code{object}. This
function must has an argument named as \code{data} that will receive the
matrix of exposures.}

\item{cmethod}{(optional) Function to obtain the classification from the object
generated with \code{method}.}

\item{...}{Passed to content of \code{method}.}

\item{warnings}{(default \code{TRUE}) If set to \code{FALSE} warnings will
not be displayed.}
}
\value{
\code{ExposomeClust} with the original exposures and the
classification of each exposure.
}
\description{
This method allows to create an \link{ExposomeClust} object from an
\link{ExposomeSet} object by clustering samples through the exposure
levels. The method is flexible to accept any clustering method
(\code{method}) that allows to obtain a classification (\code{cmethod})
of the samples. The function assigned to argument \code{method} must have
an argument called \code{data}, waiting for the matrix of exposures
(samples as rows, exposures as columns). If the result object of the
\code{method} has no accessor \code{$classification}, then a \code{cmethod}
is required and will be applied on the result of \code{method} to obtain
a labelled vector with the samples' classification.
}
\note{
The function assigned to \code{cmethod} will be directy applied to
the result of the \code{method} as: \code{cmethod(model)}; being
\code{model} the result of \code{method}.
}
\examples{
data("exposome")

# EXAMPLE 1: Clustering with mclust
library(mclust)
c <- clustering(expo[12:32, ], method = Mclust, G = 2)
table(classification(c))  # This works since the result of Mclust has an accessor
                   # $classification

# EXAMPLE 2: Cluseting with flexmix
library(flexmix)
# First we carete a function to apply flexmix to the ExposomeSet
flexmix_clust <- function(data, ...) {
  data <- as.matrix(data)
  flexmix(formula = data~1, ...)
}

# Then if we apply the method to the ExposomeSet it will crash:
# c <- clustering(expo[12:32, ], method = flexmix_clust, k = 2, model = FLXMCmvnorm())
# Because the method does not know how to obtain the classification for the result
# since flexmix has not an accessor called $classiciation

# We create a function to get the classification
flexmix_clas <- function(model, ...) {
  return(clusters(model))
}

# We put it to the ExposomeClust
c <- clustering(expo[12:32, ], method = flexmix_clust, cmethod = flexmix_clas,
    k = 2, model = FLXMCmvnorm())
classification(c) # This works because the ExposomeClust has a way to get
                  # the classification
}
\seealso{
\link{classification} to see how to obtain the classification of
the samples from an \link{ExposomeClust}, \link{plotClassification} to
plot the groups
}
