% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLZMatrix.R
\name{makeLZMatrix}
\alias{makeLZMatrix}
\title{Make Local Z-Score Matrix}
\usage{
makeLZMatrix(mlZA, normalize = TRUE, clusterize = TRUE,
                centralize = NA, hc.method = NULL, dist.method = "euclidean",
                scale = FALSE, ...)
}
\arguments{
\item{mlZA}{an object of class \link[=multiLocalZScore-class]{multiLocalZScore} or a numerical matrix.}

\item{normalize}{logical, if TRUE the z-score values in the matrix will be normalized. (default = FALSE)}

\item{clusterize}{logical, if TRUE the matrix will be clustered using the method specified by \code{hc.method} (default = TRUE)}

\item{centralize}{numeric, only z-score values in a number of steps (defined by \code{centralize}) around the center of the local association will be used for clustering. If NA, all the values in the matrix will be used for clustering. (default = NA)}

\item{hc.method}{character, select the \code{\link[=hclust]{hclust()}} method to use for clustering the matrix. If NULL, the clustering method will be automatically selected by the function \code{\link[=chooseHclustMet]{chooseHclustMet()}}. (default = NULL)}

\item{dist.method}{character, the distance measure to be used from those available in \code{\link[=dist]{dist()}} . (default = "euclidean")}

\item{scale}{logical, if TRUE the matrix will be scaled. (default = FALSE)}

\item{...}{further arguments to be passed to other methods.}
}
\value{
A object of class \link[=multiLocalZScore-class]{multiLocalZScore} containing three slots, with a populated \code{matrix} slot.

\itemize{
\item \bold{\code{@parameters}}
\item \bold{\code{@multiLocalZscores}}
\item \bold{\code{@matrix}}

}
}
\description{
Create a local z-score matrix from a \link[=multiLocalZScore-class]{multiLocalZScore}
object and save it in its \code{matrix} slot.
}
\examples{

data("cw_Alien")



}
\seealso{
\code{\link{localZScore}}
}
