#' @title cw_Alien
#'
#' @description
#'
#' Alien Genome crosswise matrix using [regioneR::randomizeRegions] , [regioneR::circularRandomizeRegions],
#' [regioneR::resampleRegions], [regioneR::resampleGenome] functions as permutation strategies.
#'
#' @name cw_Alien
#' @docType data
#' @usage data(cw_Alien)
#' @format An objects of class [genoMatriXeR][genoMatriXeR-class]; see [makeCrosswiseMatrix()].
#'
#' @keywords datasets
#'
NULL #"cw_Alien"




#' @title AlienGenome
#'
#' @description
#'
#' The Alien Genome is an artificial genomic coordinates system for the purposes
#' of testing and demonstrating the functions of regioneReload with a low
#' computing time.
#'
#' @details
#'
#' The Alien Genome consists of four chromosomes and is generated by the
#' following code:
#'
#' \preformatted{AlienGenome <-
#' toGRanges(data.frame(
#'   chr = c("AlChr1", "AlChr2", "AlChr3", "AlChr4"),
#'   start = c(rep(1, 4)),
#'   end = c(2e6, 1e6, 5e5, 1e5)
#' ))}
#'
#' @name AlienGenome
#' @docType data
#' @usage data(cw_Alien)
#' @format An objects of class [GRanges][GenomicRanges::GRanges].
#'
#' @keywords datasets
#'
NULL #"cw_Alien"





#' @title AlienRSList_narrow
#'
#' @description
#'
#' List of region sets (as [GRanges][GenomicRanges::GRanges]) on the [AlienGenome].
#'
#' @details
#'
#' This region sets are generated for the purpose of demonstrating the functions
#' of RegioneReloaded with a low computing time and "predictable" associations. The
#' regions are generated with by combining [createRandomRegions()] and
#' [similarRegionSet()] so that there is a known overlap between certain region
#' sets. To see a full description of this sample data and the code used to
#' generate it, see the RegioneReloaded vignette.
#'
#' @name AlienRSList_narrow
#' @docType data
#' @usage data(cw_Alien)
#' @format A list of [GRanges][GenomicRanges::GRanges] objects.
#'
#' @keywords datasets
#'
NULL #"cw_Alien"





#' @title AlienRSList_broad
#'
#' @description
#'
#' List of region sets (as [GRanges][GenomicRanges::GRanges]) on the [AlienGenome].
#'
#' @details
#'
#' This region sets are generated for the purpose of demonstrating the functions
#' of RegioneReloaded with a low computing time and "predictable" associations. The
#' regions are generated with by combining [createRandomRegions()] and
#' [similarRegionSet()] so that there is a known overlap between certain region
#' sets. To see a full description of this sample data and the code used to
#' generate it, see the RegioneReloaded vignette.
#'
#' @name AlienRSList_broad
#' @docType data
#' @usage data(cw_Alien)
#' @format A list of [GRanges][GenomicRanges::GRanges] objects.
#'
#' @keywords datasets
#'
NULL #"cw_Alien"




#' @title cw_Alien_RaR
#'
#' @description
#'
#' Alien Genome crosswise matrix using [regioneR::randomizeRegions()]
#' function a permutation strategy. Alist = AlienRSList_narrow, Blist = AlienRSList_narrow
#'
#' @name cw_Alien_RaR
#' @docType data
#' @usage data(cw_Alien)
#' @format An objects of class [genoMatriXeR][genoMatriXeR-class]; see [makeCrosswiseMatrix()].
#'
#' @keywords datasets
#'
NULL #"cw_Alien"



#' @title cw_Alien_ReG
#'
#' @description
#'
#' Alien Genome crosswise matrix using [regioneR::resampleGenome()] function as permutations
#' trategy. Alist = AlienRSList_narrow, Blist = AlienRSList_narrow
#'
#' @name cw_Alien_ReG
#' @docType data
#' @usage data(cw_Alien)
#' @format An objects of class [genoMatriXeR][genoMatriXeR-class]; see [makeCrosswiseMatrix()].
#'
#' @keywords datasets
#'
NULL #"cw_Alien"



#' @title cw_Alien_ReR
#'
#' @description
#'
#' Alien Genome crosswise matrix using [regioneR::resampleRegions()] function a permutation
#' strategy.Alist = AlienRSList_narrow, Blist = AlienRSList_narrow
#'
#' @name cw_Alien_ReR
#' @docType data
#' @usage data(cw_Alien)
#' @format An objects of class [genoMatriXeR][genoMatriXeR-class]; see [makeCrosswiseMatrix()].
#'
#' @keywords datasets
#'
NULL #"cw_Alien"



#' @title cw_Alien_ReG_no_Square
#'
#' @description
#'
#' Alien Genome crosswise matrix using [regioneR::resampleGenome()] function as permutations
#' trategy. Alist = AlienRSList_narrow, Blist = AlienRSList_broad
#'
#' @name cw_Alien_ReG_no_Square
#' @docType data
#' @usage data(cw_Alien)
#' @format An objects of class [genoMatriXeR][genoMatriXeR-class]; see [makeCrosswiseMatrix()].
#'
#' @keywords datasets
#'
NULL #"cw_Alien"



#' @title mLZ_regA_ReG
#'
#' @description
#'
#' Alien Genome multiLocalZScore calculated for regA regionset from AlienRSList_narrow using [regioneR::resampleGenome()] function as permutation s
#' trategy.
#'
#' @name mLZ_regA_ReG
#' @docType data
#' @usage data(cw_Alien)
#' @format An objects of class [multiLocalZScore][multiLocalZScore-class]; see [makeLZMatrix()].
#'
#' @keywords datasets
#'
NULL #"cw_Alien"



#' @title mLZ_regA_ReG_br
#'
#' @description
#'
#' Alien Genome multiLocalZScore calculated for regA regionset from AlienRSList_broad using [regioneR::resampleGenome()] function as permutation s
#' trategy.
#'
#' @name mLZ_regA_ReG_br
#' @docType data
#' @usage data(cw_Alien)
#' @format An object of class [multiLocalZScore][multiLocalZScore-class]
NULL



#' @title mLZ_regD_ReG
#'
#' @description
#'
#' Alien Genome multiLocalZScore calculated for regD regionset from AlienRSList_narrow using [regioneR::resampleGenome()] function as permutation s
#' trategy.
#'
#' @name mLZ_regD_ReG
#' @docType data
#' @usage data(cw_Alien)
#' @format An object of class [multiLocalZScore][multiLocalZScore-class]
NULL
