% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse_study.R
\name{browse_study}
\alias{browse_study}
\title{Open a SRA study id in the SRA website}
\usage{
browse_study(project, browse = interactive())
}
\arguments{
\item{project}{A character vector with at least one SRA study id.}

\item{browse}{Whether to open the resulting URL in the browser.}
}
\value{
Returns invisibly the URL for exploring the study in the SRA website.
}
\description{
Given a SRA study id get the url to browse the study using the SRA website.
}
\examples{
## Find the Geuvadis consortium project
id <- abstract_search("Geuvadis consortium", id_only = TRUE)
id

## Explore the Geuvadis consortium project
url <- browse_study(id)

## See the actual URL
url
}
\seealso{
\link{abstract_search}
}
\author{
Leonardo Collado-Torres
}
