#' Summary information at the project level for the recount project
#'
#' A data.frame with summary information at the project level for the studies
#' analyzed in the recount project.
#'
#' @name recount_abstract
#' @docType data
#' @format A data.frame with 4 columns.
#' \describe{
#'     \item{number_samples }{ the number of samples in the study,}
#'     \item{species }{ the species of the study,}
#'     \item{abstract }{ the abstract text as provided by the SRAdb Bioconductor
#'     package,}
#'     \item{project }{ the SRA project id.}
#' }
#'
#' @keywords datasets
#' @seealso [download_study]
#' @references <https://jhubiostatistics.shinyapps.io/recount/>
NULL
