% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{link}
\alias{link}
\title{Create a link to a different book}
\usage{
link(id, package, type = NULL, prefix = NULL, df = NULL, error = TRUE)
}
\arguments{
\item{id}{String containing an identifier for a section or figure.}

\item{package}{String containing the name of the package containing the target book.}

\item{type}{String containing the type of the link, e.g., \code{"Section"} or \code{"Figure"}, to be added to the link text.
This is automatically determined if not provided.
If \code{NA}, the type is not added to the link text.}

\item{prefix}{String specifying the prefix to use on \code{type}.
This is automatically determined from \code{package}'s chosen prefix or, if that is not provided, using the package name itself.
If \code{NA}, no prefix is added.
Only used if \code{type} is not \code{NA}.}

\item{df}{A data.frame containing all links for \code{package}.
Only used for testing.}

\item{error}{Logical scalar indicating whether an error should be raised if the link cannot be found.}
}
\value{
String containing a markdown-formatted link to the relevant part of the target book.
If the link cannot be constructed and \code{error=FALSE}, a \code{NULL} is instead returned.
}
\description{
From another Rmarkdown file, create a link to a section or figure of a \pkg{rebook}-configured book.
}
\details{
We expect that the target book is set up as a Bioconductor package with a \code{configure} file that runs \code{\link{configureBook}}.
This function will then retrieve install-time information from that package to create necessary hyperlinks to the Bioconductor-hosted book content.
}
\examples{
# Only using 'df=' here because 'testpackage' doesn't actually exist.
link("fig:xxx", package="testpackage", 
    df=data.frame(id='fig:xxx', file='whee.html', text='3.1'))

link("fig:xxx", package="testpackage", type=NA,
    df=data.frame(id='fig:xxx', file='whee.html', text='3.1'))

link("fig:xxx", package="testpackage", prefix=NA,
    df=data.frame(id='fig:xxx', file='whee.html', text='3.1'))
}
\seealso{
\code{\link{configureBook}}, which should be run by the authors of \code{package}.

\code{\link{scrapeReferences}}, to generate a \code{df} for testing.
}
\author{
Aaron Lun
}
