% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chapterPreamble.R
\name{chapterPreamble}
\alias{chapterPreamble}
\title{Execute chapter preamble code}
\usage{
chapterPreamble(cache = TRUE)
}
\arguments{
\item{cache}{Logical indicating whether to cache code chunks.}
}
\value{
HTML is printed to standard output, see \code{\link{setupHTML}}.
}
\description{
Execute code to set up the compilation environment at the start of every chapter.
}
\details{
Compilation is performed with no tolerance for errors, no printing of package start-up messages, 
and no printing of warnings.

Numbers are printed to 4 digits of precision.

The \pkg{BiocStyle} package is automatically attached, primarily for use of \code{\link{Biocpkg}} and similar functions.

HTML elements are defined using \code{\link{setupHTML}}.
}
\examples{
tmp <- tempfile(fileext=".Rmd")
write(file=tmp, "```{r, echo=FALSE, results='asis'}
rebook::chapterPreamble()
```

```{r}
pi # four digits!
```

```{r}
warning('ASDASD') # warnings and messages are not saved in the HTML.
```

```{r, results='asis'}
prettySessionInfo()
```")

rmarkdown::render(tmp)

if (interactive()) browseURL(sub(".Rmd$", ".html", tmp))

}
\author{
Aaron Lun
}
