% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randRot.R
\name{initRandrotW}
\alias{initRandrotW}
\title{Internal function}
\usage{
initRandrotW(Y, X, coef.h, coef.d, weights, cormat, cholCinv, tcholC)
}
\arguments{
\item{Y}{a data matrix with \code{features x samples} dimensions or a list
with elements \code{E}, \code{design} and \code{weights} (see
\code{Details}). Missing values (\code{\link[base:NA]{NA}}) are allowed but
e.g. lead to NAs for all samples of the respective features in the rotated
dataset and should thus be avoided. We highly recommend avoiding missing
values by e.g. replacing them by imputation or removing features containing
NAs.}

\item{X}{the design matrix of the experiment with \code{samples x
coefficients} dimensions. For \code{initBatchRandrot}, specify the design
matrix without the batch variable. A warning is generated if
\code{X[,coef.d]} does not have full rank, see Details.}

\item{coef.h}{single integer or vector of integers specifying the "hypothesis
coefficients" (\code{H0} coefficients). \code{coef.h} should correspond to
the last columns in \code{X} (see \code{Details}). If available,
\code{attr(X, "coef.h")} is used, see
\code{\link[randRotation:contrastModel]{contrastModel}}. By default, all
coefficients are set as \code{H0} coefficients. If \code{coef.h} is set
\code{-1}, no coefficient is set as \code{H0} coefficient.}

\item{coef.d}{Determined coefficients. These are all other coefficients that
are not hypothesis coefficients (see also
\code{\link[randRotation:initRandrot]{initRandrot}}).}

\item{weights}{numerical matrix of finite positive weights > 0 (as in
weighted least squares regression. Dimensions must be equal to dimensions
of \code{Y}.}

\item{cormat}{the sample correlation matrix with \code{samples x samples}
dimensions. Must be a real symmetric positive-definite square matrix. See
\code{Details} for usage in \code{initBatchRandrot}.}

\item{cholCinv}{Inverse of the Cholesky factorisation of \code{cormat}.}

\item{tcholC}{Transposed of the Cholesky factorisation of \code{cormat}.}
}
\value{
An initialised
  \code{\link[randRotation:initRandrot-class]{initRandrotW}} object.
}
\description{
Internal function
}
\examples{
# For further examples see '?rotateStat' and package vignette.

#set.seed(0)

# Dataframe of phenotype data (sample information)
# We simulate 2 sample classes processed in 3 batches
pdata <- data.frame(phenotype = rep(c("Control", "Cancer"), c(5,5)))
features <- 100

# Matrix with random gene expression data
edata <- matrix(rnorm(features * nrow(pdata)), features)
rownames(edata) <- paste("feature", 1:nrow(edata))

mod1 <- model.matrix(~phenotype, pdata)

### Simulate weights
weights <- matrix(rbeta(features * nrow(pdata), 2, 2)+0.1, features)

# Initialisation of the random rotation class
init1 <- initRandrot(Y = edata, X = mod1, coef.h = 2,
                        weights = weights)
init1
}
\author{
Peter Hettegger
}
\keyword{internal}
