% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randRot.R
\name{.fdr.qu}
\alias{.fdr.qu}
\alias{.fdr.q}
\alias{.pFdr}
\title{Internal functions for p-value and FDR estimation}
\usage{
.fdr.qu(
  s0,
  stats,
  beta = 0.05,
  na.rm = FALSE,
  ref.vector = sort(s0, decreasing = TRUE, na.last = TRUE)
)

.fdr.q(
  s0,
  stats,
  beta = 0.05,
  na.rm = FALSE,
  ref.vector = sort(s0, decreasing = TRUE, na.last = TRUE)
)

.pFdr(s0, stats, method, pooled, na.rm, beta)
}
\arguments{
\item{s0}{\code{numeric} vector of original (non-rotated) statistics.}

\item{stats}{\code{numeric} matrix of rotated statistics.}

\item{beta}{\code{numeric} between 0 and 1. See \insertCite{Yekutieli1999}{randRotation}.}

\item{na.rm}{\code{logical}. Should missing values be removed ?}

\item{ref.vector}{Reference vector defining at which grid points of \code{s0}
and (\code{stats}) the FDRs are approximated. All other points are
approximated by spline interpolation. NAs are removed from ref.vector}

\item{method}{A p-value or FDR adjustment method, see
\code{\link[randRotation:pFdr]{pFdr}}.}

\item{pooled}{\code{logical}. \code{TRUE} if marginal distributions are
exchangeable for all features so that rotated stats can be pooled, see
\code{\link[randRotation:pFdr]{pFdr}}.}
}
\value{
\code{numeric} vector of (adjusted) p-value or FDR estimations for \code{s0}.
}
\description{
Internal functions for p-value and FDR estimation
}
\references{
\insertAllCited{}
}
\keyword{internal}
