% Generated by roxygen2 (4.0.1): do not edit by hand
\name{rain}
\alias{rain}
\title{Detection of rhythmic behavior in time series.}
\usage{
rain(x, deltat, period, period.delta = 0, peak.border = c(0.3, 0.7),
  nr.series = 1, measure.sequence = NULL, method = "independent",
  na.rm = FALSE, adjp.method = "ABH", verbose = getOption("verbose"))
}
\arguments{
\item{x}{numeric array, containing the data. One row per time point,
one column per sample. If more than one replicate is done, see
nr.series for formatting.}

\item{deltat}{numeric: sampling interval.}

\item{period}{numeric: Period to search for.
The given period is mapped to the best matching number of measurements.
A set of periods can be defined by period and period.delta.}

\item{period.delta}{numeric: width of period interval.
A interval of different period-length to evaluate is defined by
period $-$ period.delta and period $+$ period.delta.
In this interval all possible numbers of time points according to the
deltat are tested.}

\item{peak.border}{vector c(min,max): defines the different form of the
peak. min and max have to be >0 and <1. The concrete interpretation depends
on the chosen method (see Details). (default = c(0.3,0.7))}

\item{nr.series}{numeric: Number of replicates of the whole time series.
If using nr.series all series have to have the same length.
These multiple time series contained in x must be organized timepoint by
timepoint using the following format
[r1t1, r2t1, r1t2, r2t2, ..., r1tn, r2tn]
where ritj is the i'th repeat of the j'th time-point.}

\item{measure.sequence}{numeric array: Numbers of replicates for each time
point.
By using 'measure.sequence', irregular time courses may be evaluated.
A value of 0 is possible and handeled correctly. The array determines how
many values are present for each time piont.
The values are ordered in the same format as specified above.
measure.sequence overwrites nr.series if both are set.}

\item{method}{string ('independent', 'longitudinal'): identify the method
to use (see Details).}

\item{na.rm}{boolean: calculate individual statistics for time series
containign NAs. The time series of a sample containing NAs is treated
as if the time points with NA are not measured. Using this option increases
calculation time.}

\item{adjp.method}{string (see \code{\link[multtest]{mt.rawp2adjp}}):
select the method wich is used for the multiple testing correction for the
different phases and periods and shapes tested}

\item{verbose}{status output}
}
\value{
An array containing p-values and the description of the best
matching model.
Each row apply to a sample in x.
   \item{pVal }{The p-Values}
   \item{phase }{The phase of the peak (see Details)}
   \item{peak.shape }{The shape of the curve depending on the method used
   (see Details)}
   \item{period }{The period length, same unit as deltat}
}
\description{
rain detects rhythms in time-series using non parametric methods.
It uses an extension of the rank test for Umbrella Alternatives
(Mack & Wolfe, 1981), based on on the Jonckheere-Terpstra test, which tests
whether sets of groups have a trend or not.  The Umbrella method extends
this to independent rising and falling sets.
}
\details{
The method tests whether a the time course consists of alternating rising
and falling slopes, repeated with a distinct period. The partitions of the
rising part with respect to the whole period are given by
peak.border = c(min, max). The value peak.shape specifies this partition in
the best matching model. The phase is defined as the time point with the
peak. There are two versions of umbrella:
\describe{
\item{independent}{Multiple periods are interpreted as repeats of one
period.}
\item{logitudinal}{The whole time series remains unaffected. Partial slopes
in the beginning and end of the time series are evaluated as shorter
slopes. This method implicitly rejects underlying trends.This should be
used only with longitudinal samples, hat may contain strong trends}
}
}
\examples{
# create a dataset with different noise levels
noise.levels <- c(1, 0.5, 0.2, 0.1, 0.05, 0.02)
period <- 15
testset <- apply(matrix(noise.levels, nrow = 1), 2, function(noise){
   timecourse = 1 + 0.4 * cos((1:30) / period * 2 * pi) +
   rnorm(30, 0, noise)
})


results <- rain(testset, period=15, deltat=1, method='independent')

plot(-log(results$pVal) ~ noise.levels)

\dontrun{
# testing a biological dataset
data(menetRNASeqMouseLiver)
menet.ossc <- rain(t( menetRNASeqMouseLiver ), deltat = 4, period = 24,
   nr.series = 2, peak.border = c(0.3, 0.7), verbose=TRUE)
require('lattice')

best <- order(results$pVal)[1:10]

xyplot(as.matrix(menetRNASeqMouseLiver
   [best, (0:5 * 2 + rep(c(1, 2), each = 6))])
 ~rep(0:11 * 4 + 2, each = 10) |rownames(menetRNASeqMouseLiver)[best],
 scales = list(y = list(relation = 'free')),
 layout = c(2, 5), type = 'b', pch = 16, xlab = 'time',
 ylab = 'expression value', cex.lab = 1)

}
}
\author{
Paul F. Thaben
}
\references{
Mack, G. A., & Wolfe, D. A. (1981). K-Sample Rank Tests for Umbrella
Alternatives.
\emph{Journal of the American Statistical Association},
\bold{76(373)}, 175--181.
}
\keyword{Statistics|nonparametric}
\keyword{Statistics|ts}

