/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BarcodeUtils {
    public static Map<String, String> readBarcodeFile(File barcodeFile) throws IOException, BarcodeInvalidException {
        return BarcodeUtils.readBarcodeFile(new FileReader(barcodeFile));
    }

    public static Map<String, String> readBarcodeFile(InputStream is) throws IOException, BarcodeInvalidException {
        return BarcodeUtils.readBarcodeFile(new InputStreamReader(is));
    }

    public static Map<String, String> readBarcodeFile(Reader r) throws IOException, BarcodeInvalidException {
        String line;
        HashMap<String, String> ret = new HashMap<String, String>();
        BufferedReader reader = null;
        reader = reader instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.trim().split("\\s+");
            if (tokens.length != 2 && tokens.length != 3) continue;
            String tag = tokens[0].toLowerCase();
            if (ret.containsKey(tag)) {
                throw new BarcodeInvalidException("Barcode for " + (String)ret.get(tag) + " and " + tokens[1] + " are both " + tag);
            }
            ret.put(tag, tokens[1]);
        }
        reader.close();
        ArrayList barcodes = new ArrayList(ret.keySet());
        for (int row = 0; row < barcodes.size(); ++row) {
            String barcode1 = (String)barcodes.get(row);
            for (int col = row + 1; col < barcodes.size(); ++col) {
                String barcode2 = (String)barcodes.get(col);
                if (barcode1.startsWith(barcode2)) {
                    throw new BarcodeInvalidException("Barcode " + barcode2 + " (" + (String)ret.get(barcode2) + ") is a prefix of barcode " + barcode1 + " (" + (String)ret.get(barcode1) + ")");
                }
                if (!barcode2.startsWith(barcode1)) continue;
                throw new BarcodeInvalidException("Barcode " + barcode1 + " (" + (String)ret.get(barcode1) + ") is a prefix of barcode " + barcode2 + " (" + (String)ret.get(barcode2) + ")");
            }
        }
        return ret;
    }

    public static class BarcodeInvalidException
    extends Exception {
        public BarcodeInvalidException(String str) {
            super(str);
        }
    }
}

