/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare;

import edu.msu.cme.rdp.classifier.cli.CmdOptions;
import edu.msu.cme.rdp.classifier.io.ClassificationResultFormatter;
import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.multicompare.MCSampleResult;
import edu.msu.cme.rdp.multicompare.MultiClassifier;
import edu.msu.cme.rdp.multicompare.MultiClassifierResult;
import edu.msu.cme.rdp.multicompare.visitors.DefaultPrintVisitor;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.output.NullWriter;

public class Reprocess {
    private static Options options = new Options();

    public static HashSet<String> readTaxonFilterFile(String file) throws IOException {
        String line;
        HashSet<String> ret = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            if (line.trim().equals("")) continue;
            ret.add(line.trim());
            System.err.println(line.trim());
        }
        reader.close();
        return ret;
    }

    public static void main(String[] args) throws Exception {
        PrintWriter assign_out = new PrintWriter(new NullWriter());
        float conf = 0.8f;
        PrintStream heir_out = null;
        String hier_out_filename = null;
        ClassificationResultFormatter.FORMAT format = ClassificationResultFormatter.FORMAT.allRank;
        String rank = null;
        String taxonFilterFile = null;
        String train_propfile = null;
        String gene = null;
        ArrayList<MCSample> samples = new ArrayList<MCSample>();
        try {
            CommandLine line = new PosixParser().parse(options, args);
            if (!line.hasOption("h")) {
                throw new Exception("It make sense to provide output filename for hier_outfile");
            }
            hier_out_filename = line.getOptionValue("h");
            heir_out = new PrintStream(hier_out_filename);
            if (line.hasOption("o")) {
                assign_out = new PrintWriter(line.getOptionValue("o"));
            }
            if (line.hasOption("r")) {
                rank = line.getOptionValue("r");
            }
            if (line.hasOption("n")) {
                taxonFilterFile = line.getOptionValue("n");
            }
            if (line.hasOption("c") && ((conf = Float.parseFloat(line.getOptionValue("c"))) < 0.0f || conf > 1.0f)) {
                throw new IllegalArgumentException("Confidence must be in the range [0,1]");
            }
            if (line.hasOption("f")) {
                String[] f = line.getOptionValue("f");
                if (f.equalsIgnoreCase("allrank")) {
                    format = ClassificationResultFormatter.FORMAT.allRank;
                } else if (f.equalsIgnoreCase("fixrank")) {
                    format = ClassificationResultFormatter.FORMAT.fixRank;
                } else if (f.equalsIgnoreCase("db")) {
                    format = ClassificationResultFormatter.FORMAT.dbformat;
                } else if (f.equalsIgnoreCase("filterbyconf")) {
                    format = ClassificationResultFormatter.FORMAT.filterbyconf;
                } else {
                    throw new IllegalArgumentException("Not valid output format, only allrank, fixrank, filterbyconf and db allowed");
                }
            }
            if (line.hasOption("t")) {
                if (gene != null) {
                    throw new IllegalArgumentException("Already specified the gene from the default location. Can not specify train_propfile");
                }
                train_propfile = line.getOptionValue("t");
            }
            if (line.hasOption("g")) {
                if (train_propfile != null) {
                    throw new IllegalArgumentException("Already specified train_propfile. Can not specify gene any more");
                }
                gene = line.getOptionValue("g").toLowerCase();
                if (!(gene.equals("16srrna") || gene.equals("fungallsu") || gene.equals("fungalits_warcup") || gene.equals("fungalits_unite"))) {
                    throw new IllegalArgumentException(gene + " is NOT valid, only allows " + "16srrna" + ", " + "fungallsu" + ", " + "fungalits_warcup" + " and " + "fungalits_unite");
                }
            }
            if ((args = line.getArgs()).length < 1) {
                throw new Exception("Incorrect number of command line arguments");
            }
            for (String arg : args) {
                String[] inFileNames = arg.split(",");
                String inputFile = inFileNames[0];
                File idmappingFile = null;
                if (inFileNames.length == 2 && !(idmappingFile = new File(inFileNames[1])).exists()) {
                    System.err.println("Failed to find input file \"" + inFileNames[1] + "\"");
                    return;
                }
                MCSampleResult nextSample = new MCSampleResult(inputFile, idmappingFile);
                samples.add(nextSample);
            }
        }
        catch (Exception e) {
            System.out.println("Command Error: " + e.getMessage());
            new HelpFormatter().printHelp(120, "Reprocess [options] <Classification_allrank_result>[,idmappingfile] ...", "", options, "");
            return;
        }
        if (train_propfile == null && gene == null) {
            gene = "16srrna";
        }
        HashSet<String> taxonFilter = null;
        if (taxonFilterFile != null) {
            taxonFilter = Reprocess.readTaxonFilterFile(taxonFilterFile);
        }
        MultiClassifier multiClassifier = new MultiClassifier(train_propfile, gene);
        DefaultPrintVisitor printVisitor = new DefaultPrintVisitor(heir_out, samples);
        MultiClassifierResult result = multiClassifier.multiClassificationParser(samples, conf, assign_out, format, rank, taxonFilter);
        result.getRoot().topDownVisit((TreeVisitor)printVisitor);
        assign_out.close();
        heir_out.close();
        if (multiClassifier.hasCopyNumber()) {
            File cn_corrected_s = new File(new File(hier_out_filename).getParentFile(), "cncorrected_" + hier_out_filename);
            PrintStream cn_corrected_hier_out = new PrintStream(cn_corrected_s);
            printVisitor = new DefaultPrintVisitor(cn_corrected_hier_out, samples, true);
            result.getRoot().topDownVisit((TreeVisitor)printVisitor);
            cn_corrected_hier_out.close();
        }
    }

    static {
        options.addOption(new Option("h", "hier_outfile", true, "tab-delimited output file containing the assignment count for each taxon in the hierarchical format. Default is null."));
        options.addOption(new Option("o", "outputFile", true, "tab-delimited text output file for classification assignment."));
        options.addOption(new Option("r", "rank", true, "the rank to apply the confidence cutoff. Only assignment reuslts with confidence above the cutoff at the specified rank will be included in the assignment detail outfile. Default is the lowest rank"));
        options.addOption(new Option("n", "taxon", true, "the taxon name filter containing one taxon per line.\nOnly assignment results matching the taxon name will be included in assignment detail outfile."));
        options.addOption(new Option("f", "format", true, CmdOptions.FORMAT_DESC));
        options.addOption(new Option("c", "conf", true, CmdOptions.BOOTSTRAP_DESC));
        options.addOption(new Option("t", "train_propfile", true, "property file containing the mapping of the training files if not using the default. Note: the training files and the property file should be in the same directory."));
        options.addOption(new Option("g", "gene", true, CmdOptions.GENE_DESC));
    }
}

