% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeBiopax.R
\name{uniteGraphs}
\alias{uniteGraphs}
\title{This function unites two graphs.}
\usage{
uniteGraphs(
  graph1,
  graph2,
  colorNodes = TRUE,
  colors = c("#B3E2CD", "#FDCDAC", "#F4CAE4")
)
}
\arguments{
\item{graph1}{graphNEL}

\item{graph2}{graphNEL}

\item{colorNodes}{logical}

\item{colors}{colors character vector of colors. If colorNodes==TRUE these colors are used for graph1 and graph2 respectivley.}
}
\value{
Return a graph generated by uniting the two supplied graphs
}
\description{
This function unites the two supplied graphs. Layout parameters from graph1 are used. 
If colorNodes==TRUE the returned graph has different colors for overlapping nodes and nodes individual for each graph.
}
\examples{
 # load data
 data(biopaxexample)
 pwid1 = "pid_p_100002_wntpathway"
 pwid2 = "pid_p_100146_hespathway"
 mygraph1 = pathway2RegulatoryGraph(biopax, pwid1)
 mygraph2 = pathway2RegulatoryGraph(biopax, pwid2)
 plotRegulatoryGraph(uniteGraphs(mygraph1,mygraph2))
}
\author{
Frank Kramer
}
