% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectBiopax.R
\name{getInstanceProperty}
\alias{getInstanceProperty}
\title{This function returns all properties of the specified type for an instance.}
\usage{
getInstanceProperty(
  biopax,
  id,
  property = "NAME",
  includeAllNames = TRUE,
  biopaxlevel = 3
)
}
\arguments{
\item{biopax}{A biopax model}

\item{id}{string}

\item{property}{string.}

\item{includeAllNames}{logical. Biopax Level 3 brought 2 new name properties: displayName and standardName. Per default this return all names of an instance. Disable if you only want the NAME property.}

\item{biopaxlevel}{integer. Set the biopax level here if you supply a data.table directly.}
}
\value{
Returns a character vector with all properties of the selected type for this instance. Returns NULL if no property data is found.
}
\description{
This function returns all properties of the specified type for an instance. By default this function returns the NAME property of an instance.
}
\examples{
 # load data
 data(biopaxexample)
 getInstanceProperty(biopax, id="ex_m_100650", property="NAME")
 getInstanceProperty(biopax, id="ex_m_100650", property="ORGANISM")
 getInstanceProperty(biopax, id="ex_m_100650", property="COMPONENTS")
}
\author{
fkramer
}
