% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiseqr_helpers.R
\name{eset_to_matrix}
\alias{eset_to_matrix}
\title{Convert a \code{Biobase::ExpressionSet} to a gene-expression matrix.}
\usage{
eset_to_matrix(eset, column)
}
\arguments{
\item{eset}{\code{ExpressionSet}}

\item{column}{column name of the \code{fData()} table, which contains the HGNC gene symbols.}
}
\value{
A matrix with gene symbols as rownames and sample identifiers as colnames.
}
\description{
Convert a \code{Biobase::ExpressionSet} to a gene-expression matrix.
}
\examples{

data(dataset_racle)
dim(dataset_racle$expr_mat)

library("Biobase")
es_racle <- ExpressionSet(assayData = dataset_racle$expr_mat)
featureData(es_racle)$gene_symbol <- rownames(dataset_racle$expr_mat)

es_racle

head(eset_to_matrix(es_racle, "gene_symbol"))

}
