% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeFeatures-functions.R
\name{removeICC}
\alias{removeICC}
\title{Feature Filtering based on ICC}
\usage{
removeICC(
  x,
  qc_samples,
  bio_samples = setdiff(colnames(x), qc_samples),
  cut = 0.4
)
}
\arguments{
\item{x}{A matrix-like object.}

\item{qc_samples}{A vector of sample names or column indices specifying QC
samples for the calculation of ICC. Must be a subset of
\code{colnames(x)} if it is a character vector.}

\item{bio_samples}{A vector of sample names or column indices specifying
biological samples for the calculation of ICC. Must be a subset of
\code{colnames(x)} if it is a character vector.}

\item{cut}{A numeric value between 0 and 1 specifying a ICC cut-off to
retain a feature.}
}
\value{
A matrix containing the filtered features.
}
\description{
Removes Features based on a intraclass correlation coefficient (ICC) using
the data matrix where rows represent features and columns represent samples.
For each feature, ICC will be calculated using both biological and QC
samples to identify how much of the total variation is explained by
biological variability, as described in Schiffman, C et al (2019).
Informative features are expected to have relatively high variability across
the biological samples, compared to QC replicates. Features with an ICC
below a cut-off will be removed.
}
\examples{

set.seed(1e7)

m_bio_1 <- matrix(rlnorm(600, sdlog = 1), ncol = 20)
m_bio_2 <- matrix(rlnorm(200, sdlog = 0.3), ncol = 20)
m_bio <- rbind(m_bio_1, m_bio_2)
m_qc <- matrix(rlnorm(400, sdlog = 0.25), ncol = 10)
m <- cbind(m_bio, m_qc)
colnames(m) <- c(paste0("S", seq_len(20)), paste0("Q", seq_len(10)))

removeICC(m, qc_samples = paste0("Q", seq_len(10)),
          bio_samples = paste0("S", seq_len(20)))
}
\references{
Schiffman, C., Petrick, L., Perttula, K. et al. Filtering procedures for
untargeted LC-MS metabolomics data. BMC Bioinformatics 20, 334 (2019).
https://doi.org/10.1186/s12859-019-2871-9
}
\seealso{
See \link{removeFeatures} that provides a
\linkS4class{SummarizedExperiment}-friendly wrapper for this function.
}
