% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeDiffStats.R
\name{computeDiffStats}
\alias{computeDiffStats}
\title{Compute differential statistics}
\usage{
computeDiffStats(
  MSnSetObj,
  batchEffect = NULL,
  transform = TRUE,
  contrasts,
  trend = TRUE,
  robust = TRUE
)
}
\arguments{
\item{MSnSetObj}{MSnSet; An object of class MSnSet}

\item{batchEffect}{character; vector of variable(s) to correct for batch
effect, Default : "SampleGroup"}

\item{transform}{logical; apply log2 transformation to the raw intensitites}

\item{contrasts}{character; named character vector of contrasts for
differential statistics}

\item{trend}{logical; TRUE or FALSE}

\item{robust}{logical; TRUE or FALSE}
}
\value{
A list object containing three components: MSnSetObj of class
\code{MSnSet} (see \code{\link{MSnSet-class}}) object), fittedLM (fitted
linear model) and fittedContrasts. This object should be input into
getContrastResults function to get differential results.  See
\code{\link{eBayes}} function of \code{\link{limma}} for more details on
differential statistics.
}
\description{
Compute differential statistics on the given contrasts, based on
\code{\link{limma}} functions.
}
\details{
A statistical analysis for the identification of differentially regulated or
bound proteins is carried out using limma based analysis. It uses linear
models to assess differential expression in the context of multifactor
designed experiments.  Firstly, a linear model is fitted for each protein
where the model includes variables for each group and MS run. Then, log2
fold changes between comparisions are estimated. Multiple testing correction
of p-values are applied using the Benjamini-Hochberg method to control the
false discovery rate (FDR).

In order to correct for batch effect, variable(s) can be defined. It should
corresponds to a column name in pData(MSnSetObj). The default variable is
"SampleGroup" that distinguish between two groups.  If more variables are
defined they are added to default.
}
\examples{

data(human_anno)
data(exp3_OHT_ESR1)
MSnSet_data <- convertToMSnset(exp3_OHT_ESR1$intensities_qPLEX1,
                               metadata=exp3_OHT_ESR1$metadata_qPLEX1,
                               indExpData=c(7:16), 
                               Sequences=2, 
                               Accessions=6)
MSnset_norm <- groupScaling(MSnSet_data, scalingFunction=median)
MSnset_Pnorm <- summarizeIntensities(MSnset_norm, sum, human_anno)
contrasts <- c(tam.24h_vs_vehicle = "tam.24h - vehicle", 
               tam.6h_vs_vehicle = "tam.6h - vehicle")
diffstats <- computeDiffStats(MSnSetObj=MSnset_Pnorm, contrasts=contrasts)

}
