% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Raw_Methods.R, R/SetMethods.R
\name{timeLimits}
\alias{timeLimits}
\alias{timeLimits,ptrRaw-method}
\alias{timeLimits,ptrSet-method}
\title{Calculates time limits on the breath tracer}
\usage{
timeLimits(
  object,
  fracMaxTIC = 0.5,
  fracMaxTICBg = 0.2,
  derivThresholdExp = 1,
  derivThresholdBg = 0.05,
  mzBreathTracer = NULL,
  minPoints = 2,
  degreeBaseline = 1,
  baseline = TRUE,
  redefineKnots = TRUE,
  plotDel = FALSE
)

\S4method{timeLimits}{ptrRaw}(
  object,
  fracMaxTIC = 0.6,
  fracMaxTICBg = 0.2,
  derivThresholdExp = 0.5,
  derivThresholdBg = 0.05,
  mzBreathTracer = NULL,
  minPoints = 2,
  degreeBaseline = 1,
  baseline = TRUE,
  redefineKnots = TRUE,
  plotDel = FALSE
)

\S4method{timeLimits}{ptrSet}(
  object,
  fracMaxTIC = 0.5,
  fracMaxTICBg = 0.2,
  derivThresholdExp = 1,
  derivThresholdBg = 0.05,
  minPoints = 2,
  degreeBaseline = 1,
  baseline = TRUE,
  redefineKnots = TRUE,
  plotDel = FALSE
)
}
\arguments{
\item{object}{a ptrRaw or ptrSet object}

\item{fracMaxTIC}{between 0 and 1. Percentage of the maximum of the tracer 
amplitude with baseline removal. If you want a finer limitation, increase 
\code{fracMaxTIC}, indeed decrease}

\item{fracMaxTICBg}{same as fracMaxTIC but for background detection (lower than 
fracMaxTIC*max(TIC))}

\item{derivThresholdExp}{the threshold of the difference between two
successive points of the expiration}

\item{derivThresholdBg}{the threshold of the difference between two
successive points of the background}

\item{mzBreathTracer}{NULL or a integer. Correspond to a nominal masses of 
Extract Ion Current (EIC)
 whose limits you want to compute. If NULL, the limits are calculated on the 
 Total Ion Current (TIC).}

\item{minPoints}{minimum duration of an expiration (in index).}

\item{degreeBaseline}{the degree of polynomial baseline function}

\item{baseline}{logical, should the trace be baseline corrected?}

\item{redefineKnots}{logical, should the knot location must be redefined with 
the new times limits ?}

\item{plotDel}{boolean. If TRUE, the trace is plotted with limits and 
threshold.}
}
\value{
a list with expiration limits (a matrix of index, where each column 
correspond to one expiration, the first row it is the beginning and the second
the end, or NA if no limits are detected) and index of the background.
}
\description{
This function derives limits on the breath tracer indicated, where the 
intensity is greater than \code{fracMaxTIC*max(tracer)}. By setting
\code{fracMaxTIC} close to 1, the size of the limits will be restricted.
This function also determine the index corresponding to the background, where 
variation between two successive point can be control with \code{derivThreshold} 
parameter.
}
\examples{

## ptrRaw object

library(ptairData)
filePath <- system.file('extdata/exhaledAir/ind1', 'ind1-1.h5',
package = 'ptairData')
raw <- readRaw(filePath)

timLim <- timeLimits(raw, fracMaxTIC=0.9, plotDel=TRUE)
timLim_acetone <- timeLimits(raw, fracMaxTIC=0.5, mzBreathTracer = 59,
plotDel=TRUE)
}
