% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetMethods.R
\name{setSampleMetadata}
\alias{setSampleMetadata}
\title{set sampleMetadata in a ptrSet}
\usage{
setSampleMetadata(set, sampleMetadata)
}
\arguments{
\item{set}{a ptrSet object}

\item{sampleMetadata}{a data.frame with all file names of the ptrSet in 
row names}
}
\value{
the ptrSet object in argument with the sampleMetadata modified
}
\description{
Insert a samplemetada data.frame in a ptrSet object. The dataframe must 
have all file names in rownames.
}
\examples{
dirRaw <- system.file("extdata/exhaledAir", package = "ptairData")
exhaledPtrset <- createPtrSet(dir=dirRaw, setName="exhaledPtrset", 
mzCalibRef = c(21.022, 60.0525), fracMaxTIC = 0.7, saveDir = NULL )
SMD<-getSampleMetadata(exhaledPtrset )
colnames(SMD)[1]<-'individual'
exhaledPtrset<-setSampleMetadata(exhaledPtrset ,SMD)
}
