% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetMethods.R
\name{getPeakList}
\alias{getPeakList}
\title{get the peak list of a ptrSet object}
\usage{
getPeakList(set)
}
\arguments{
\item{set}{ptrSet object}
}
\value{
a list of expressionSet, where:
\itemize{
\item assay Data contains the matrix with m/z peak center in row names, and the 
quantification in cps at each time point
\item feature Data the matrix with  m/z peak center in row names, and the 
following columns: 
  \itemize{
  \item quanti_unit: the mean of the quantification over the expiration/headspace 
time limits defined 
   \item background_unit: the mean of the quantification over the background time 
limits defined 
  \item diffAbs_unit: the mean of the quantification over the expiration/headspace
time limits defined after subtracting the baseline estimated from the background 
points defined 
   \item pValLess/ pValGreater: the p-value of the unilateral t-test, who test 
that quantification (in cps) of expiration points are less/greater than the 
intensity of the background. 
   \item lower/upper: integration boundaries
   \item parameter peak: estimated peak parameter 
  }
}
}
\description{
get the peak list of a ptrSet object
}
\examples{
library(ptairData)
dirRaw <- system.file("extdata/exhaledAir", package = "ptairData")
exhaledPtrset <- createPtrSet(dir=dirRaw, setName="exhaledPtrset", 
mzCalibRef = c(21.022, 60.0525), fracMaxTIC = 0.7, saveDir = NULL )
exhaledPtrset<-detectPeak(exhaledPtrset,mz=c(21,59))
peakList<- getPeakList(exhaledPtrset )
X<-Biobase::exprs(peakList[[1]])
Y<- Biobase::fData(peakList[[1]])
head(Y)
}
