% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{convert_to_mzML}
\alias{convert_to_mzML}
\title{Convert a h5 file to mzML}
\usage{
convert_to_mzML(file)
}
\arguments{
\item{file}{A .h5 file path}
}
\value{
create a mzML file in the same directory of the h5 input file
}
\description{
convert_to_mzML create a mzML file from a h5 file in the same directory 
with the \code{writeMLData} of the \code{MSnbase} package
}
\examples{
library(ptairData)
filePathRaw <- system.file('extdata/exhaledAir/ind1', 'ind1-1.h5', 
package = 'ptairData')
# write a mzml file in the same directory
convert_to_mzML(filePathRaw)
file_mzML <- gsub(".h5", ".mzML", filePathRaw)
file.remove(file_mzML)
}
