% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{processSurvData}
\alias{processSurvData}
\title{Process survival data to calculate survival curves}
\usage{
processSurvData(
  event,
  timeStart,
  timeStop,
  followup,
  group,
  clinical,
  survTime = NULL
)
}
\arguments{
\item{event}{Character: name of column containing time of the event of
interest}

\item{timeStart}{Character: name of column containing starting time of the
interval or follow up time}

\item{timeStop}{Character: name of column containing ending time of the
interval (only relevant for interval censoring)}

\item{followup}{Character: name of column containing follow up time}

\item{group}{Character: group relative to each subject}

\item{clinical}{Data frame: clinical data}

\item{survTime}{\code{survTime} object: Times to follow up, time start, time
stop and event (optional)}
}
\value{
Data frame with terms needed to calculate survival curves
}
\description{
Process survival data to calculate survival curves
}
\details{
The \code{event} time is only used to determine whether the event
has occurred (\code{1}) or not (\code{0}) in case of missing values.

If \code{survTime = NULL}, survival times are obtained from the clinical
dataset according to the names given in \code{timeStart}, \code{timeStop},
\code{event} and \code{followup}. This may become quite slow when used in a
loop. If the aforementioned variables are constant, consider running
\code{\link{getAttributesTime}()} outside the loop and using its output via
the \code{survTime} argument of this function (see Examples).
}
\keyword{internal}
