% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_geNormalisationFiltering.R
\name{filterGeneExpr}
\alias{filterGeneExpr}
\title{Filter genes based on their expression}
\usage{
filterGeneExpr(
  geneExpr,
  minMean = 0,
  maxMean = Inf,
  minVar = 0,
  maxVar = Inf,
  minCounts = 10,
  minTotalCounts = 15
)
}
\arguments{
\item{geneExpr}{Data frame or matrix: gene expression}

\item{minMean}{Numeric: minimum of read count mean per gene}

\item{maxMean}{Numeric: maximum of read count mean per gene}

\item{minVar}{Numeric: minimum of read count variance per gene}

\item{maxVar}{Numeric: maximum of read count variance per gene}

\item{minCounts}{Numeric: minimum number of read counts per gene for a
worthwhile number of samples (check \code{\link[edgeR]{filterByExpr}} for
more information)}

\item{minTotalCounts}{Numeric: minimum total number of read counts per gene}
}
\value{
Boolean vector indicating which genes have sufficiently large counts
}
\description{
Uses \code{\link[edgeR]{filterByExpr}} to determine genes with sufficiently
large counts to retain for statistical analysis.
}
\examples{
geneExpr <- readFile("ex_gene_expression.RDS")

# Add some genes with low expression
geneExpr <- rbind(geneExpr,
                  lowReadGene1=c(rep(4:5, 10)),
                  lowReadGene2=c(rep(5:1, 10)),
                  lowReadGene3=c(rep(10:1, 10)),
                  lowReadGene4=c(rep(7:8, 10)))

# Filter out genes with low reads across samples
geneExpr[filterGeneExpr(geneExpr), ]
}
\seealso{
Other functions for gene expression pre-processing: 
\code{\link{convertGeneIdentifiers}()},
\code{\link{normaliseGeneExpression}()},
\code{\link{plotGeneExprPerSample}()},
\code{\link{plotLibrarySize}()},
\code{\link{plotRowStats}()}
}
\concept{functions for gene expression pre-processing}
