% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{diffAnalyses}
\alias{diffAnalyses}
\title{Perform statistical analyses}
\usage{
diffAnalyses(
  data,
  groups = NULL,
  analyses = c("wilcoxRankSum", "ttest", "kruskal", "levene", "fligner"),
  pvalueAdjust = "BH",
  geneExpr = NULL,
  inputID = "sparklineInput"
)
}
\arguments{
\item{data}{Data frame or matrix: gene expression or alternative splicing
quantification}

\item{groups}{Named list of characters (containing elements belonging to each
group) or character vector (containing the group of each individual sample);
if \code{NULL}, sample types are used instead when available, e.g. normal,
tumour and metastasis}

\item{analyses}{Character: statistical tests to perform (see Details)}

\item{pvalueAdjust}{Character: method used to adjust p-values (see Details)}

\item{geneExpr}{Character: name of the gene expression dataset (only required
for density sparklines available in the interactive mode)}

\item{inputID}{Character: identifier of input to get attributes of clicked
event (Shiny only)}
}
\value{
Table of statistical analyses
}
\description{
Perform statistical analyses
}
\details{
The following statistical analyses may be performed simultaneously via the
\code{analysis} argument:
\itemize{
     \item{\code{ttest} - Unpaired t-test (2 groups)}
     \item{\code{wilcoxRankSum} - Wilcoxon Rank Sum test (2 groups)}
     \item{\code{kruskal} - Kruskal test (2 or more groups)}
     \item{\code{levene} - Levene's test (2 or more groups)}
     \item{\code{fligner} - Fligner-Killeen test (2 or more groups)}
     \item{\code{density} - Sample distribution per group (only usable
     through the visual interface)}
}

The following p-value adjustment methods are supported via the
\code{pvalueAdjust} argument:
\itemize{
     \item{\code{none}: do not adjust p-values}
     \item{\code{BH}: Benjamini-Hochberg's method (false discovery rate)}
     \item{\code{BY}: Benjamini-Yekutieli's method (false discovery rate)}
     \item{\code{bonferroni}: Bonferroni correction (family-wise error rate)}
     \item{\code{holm}: Holm's method (family-wise error rate)}
     \item{\code{hochberg}: Hochberg's method (family-wise error rate)}
     \item{\code{hommel}: Hommel's method (family-wise error rate)}
}
}
\examples{
# Calculate PSI for skipped exon (SE) and mutually exclusive (MXE) events
eventType <- c("SE", "MXE")
annot <- readFile("ex_splicing_annotation.RDS")
junctionQuant <- readFile("ex_junctionQuant.RDS")

psi <- quantifySplicing(annot, junctionQuant, eventType=c("SE", "MXE"))
group <- c(rep("Normal", 3), rep("Tumour", 3))
diffAnalyses(psi, group)
}
\seealso{
Other functions to perform and plot differential analyses: 
\code{\link{plotDistribution}()}
}
\concept{functions to perform and plot differential analyses}
