% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileScoreDist.R
\name{computeScoreDist}
\alias{computeScoreDist}
\title{Compute exact position weight/count matrix score distribution.}
\usage{
computeScoreDist(motif, gc, granularity = 0.01, unit = "nat")
}
\arguments{
\item{motif}{A matrix representing a PCM or PWM; each column a position and
each row a base corresponding to A, C, G, T.  This order is assumed, unless
the rows are correspondingly named in a different order.}

\item{gc}{A scalar giving the GC fraction to assume.}

\item{granularity}{The granularity of the discretization, defaults to 0.01.}

\item{unit}{The logarithm unit of the score computed from the PCM or PWM, can
be "nat" (default, natural logarithm), "bit" (base 2), or "dit" (base 10).}
}
\value{
a ProfileDist object
}
\description{
Computes the discretisized score distribution of a position count matrix
(PCM) or a position weight matrix (PWM), using the method described by
Rahmann et al.
}
\examples{
data(INR)
thedist <- computeScoreDist(regularizeMatrix(INR), 0.5)
plotDist(thedist)
}
\references{
Rahmann, S., Mueller, T., and Vingron, M. (2003). On the power of
  profiles for transcription factor binding site detection. Stat Appl Genet
  Mol Biol 2, Article7.
}

