% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{coefficient_variance_matrices}
\alias{coefficient_variance_matrices}
\title{Get the coefficients}
\usage{
coefficient_variance_matrices(object, ...)
}
\arguments{
\item{object}{the object to get from}

\item{...}{additional arguments used by the concrete implementation}
}
\value{
a list with as many entries as rows in the data. Each element is
  a p*p matrix
}
\description{
Get the coefficients
}
\examples{
  syn_data <- generate_synthetic_data(n_proteins = 10)
  fit <- proDA(syn_data$Y, design = syn_data$groups)
  coefficient_variance_matrices(fit)

}
\seealso{
\link{accessor_methods} for the implementation for a 'proDAFit' object
}
