% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify-alternative-promoters.R
\name{getAlternativePromoters}
\alias{getAlternativePromoters}
\title{Identifies alternative promoters.}
\usage{
getAlternativePromoters(
  result,
  referenceCondition,
  minAbs = 0.25,
  minRel = 0.05,
  maxPval = 0.05,
  promoterFC = 2,
  geneFC = 1.5
)
}
\arguments{
\item{result}{A SummarizedExperiment object with assays giving promoter 
counts, activity and gene expression (output from proActiv). rowData 
contains promoter metadata and absolute promoter activity summarized 
across conditions. Condition must be provided.}

\item{referenceCondition}{A character vector. The reference condition to be 
compared. Samples corresponding to all other conditions will be compared 
to this samples in this current condition.}

\item{minAbs}{A numeric value. Minimum value for promoter to be active in 
absolute terms. Defaults to 0.25.}

\item{minRel}{A numeric value. Minimum value for promoter to be active in 
relative terms. Defaults to 0.05.}

\item{maxPval}{A numeric value. Adjusted p-value threshold for detecting 
alternative promoters. Defaults to 0.05.}

\item{promoterFC}{A numeric value. Minimum fold change for a promoter in the
current condition compared to all other conditions. Promoters must have at 
least this magnitude of fold change for alternative usage.}

\item{geneFC}{A numeric value. Maximum fold change for gene expression. To
identify alternative promoter usage independent of changes in gene 
expression, limit the gene expression fold change.}
}
\value{
A list of length 2. Each entry is a dataframe summarizing 
 up-regulated and down-regulated promoters and their corresponding genes, 
 if any.
}
\description{
Identifies alternative promoters.
}
\examples{
 
files <- list.files(system.file('extdata/vignette/junctions', 
                       package = 'proActiv'), 
                       full.names = TRUE, pattern = 'replicate5')
promoterAnnotation <- promoterAnnotation.gencode.v34.subset
result <- proActiv(files = files,
                       promoterAnnotation  = promoterAnnotation,
                       condition = rep(c('A549', 'HepG2'), each=1),
                       fileLabels = NULL,
                       ncores = 1)
alternativePromoters <- getAlternativePromoters(result, "A549")

}
