% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/junction-read-count.R
\name{calculateJunctionReadCounts}
\alias{calculateJunctionReadCounts}
\title{Calculate the total number of junction reads overlapping with the introns of
each promoter for the input junction file}
\usage{
calculateJunctionReadCounts(
  promoterCoordinates,
  intronRanges,
  file = "",
  fileType = "",
  genome = ""
)
}
\arguments{
\item{promoterCoordinates}{A GRanges object containing promoter coordinates
and reduced exon coordinates by gene}

\item{intronRanges}{A Granges object containing the annotated unique intron
ranges. These ranges will be used for counting the reads}

\item{file}{character path for the input junction bed or bam file}

\item{fileType}{character type of the junction bed file. Either 'tophat',
'star' or 'bam'}

\item{genome}{character genome version}
}
\value{
The total number of junction reads overlapping with each promoter for
  the input annotated intron ranges
}
\description{
Calculate the total number of junction reads overlapping with the introns of
each promoter for the input junction file
}
