% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PromoterAnnotation-class.R
\docType{class}
\name{PromoterAnnotation-class}
\alias{PromoterAnnotation-class}
\alias{PromoterAnnotation}
\alias{intronRanges}
\alias{intronRanges,PromoterAnnotation-method}
\alias{promoterIdMapping}
\alias{promoterIdMapping,PromoterAnnotation-method}
\alias{promoterCoordinates}
\alias{promoterCoordinates,PromoterAnnotation-method}
\alias{intronRanges<-}
\alias{intronRanges<-,PromoterAnnotation-method}
\alias{'intronRanges<-',PromoterAnnotation-method}
\alias{promoterIdMapping<-}
\alias{promoterIdMapping<-,PromoterAnnotation-method}
\alias{'promoterIdMapping<-',PromoterAnnotation-method}
\alias{promoterCoordinates<-}
\alias{promoterCoordinates<-,PromoterAnnotation-method}
\alias{'promoterCoordinates<-',PromoterAnnotation-method}
\title{S4 class for promoter annotation data for a specific annotation version}
\usage{
PromoterAnnotation(
  intronRanges = GenomicRanges::GRanges(),
  promoterIdMapping = data.frame(),
  promoterCoordinates = GenomicRanges::GRanges()
)

intronRanges(x)

\S4method{intronRanges}{PromoterAnnotation}(x)

promoterIdMapping(x)

\S4method{promoterIdMapping}{PromoterAnnotation}(x)

promoterCoordinates(x)

\S4method{promoterCoordinates}{PromoterAnnotation}(x)

intronRanges(x) <- value

\S4method{intronRanges}{PromoterAnnotation}(x) <- value

promoterIdMapping(x) <- value

\S4method{promoterIdMapping}{PromoterAnnotation}(x) <- value

promoterCoordinates(x) <- value

\S4method{promoterCoordinates}{PromoterAnnotation}(x) <- value
}
\arguments{
\item{intronRanges}{A GRanges object containing annotated intron ranges}

\item{promoterIdMapping}{A data.frame containing mapping between transcript, 
TSS, promoter and gene ids}

\item{promoterCoordinates}{A GRanges object containing promoter coordinates}

\item{x}{A PromoterAnnotation object}

\item{value}{intronRanges, promoterIdMapping or promoterCoordinates to 
be assigned}
}
\value{
A promoter annotation object with three slots: intronRanges, 
  promoterIdMapping and promoter Coordinates
}
\description{
S4 class for promoter annotation data for a specific annotation version
}
\section{Functions}{
\itemize{
\item \code{intronRanges}: Getter for intronRanges

\item \code{intronRanges,PromoterAnnotation-method}: Getter for intronRanges

\item \code{promoterIdMapping}: Getter for promoterIdMapping

\item \code{promoterIdMapping,PromoterAnnotation-method}: Getter for promoterIdMapping

\item \code{promoterCoordinates}: Getter for promoterCoordinates

\item \code{promoterCoordinates,PromoterAnnotation-method}: Getter for promoterCoordinates

\item \code{intronRanges<-}: Setter for intronRanges

\item \code{intronRanges<-,PromoterAnnotation-method}: Setter for intronRanges

\item \code{promoterIdMapping<-}: Setter for promoterIdMapping

\item \code{promoterIdMapping<-,PromoterAnnotation-method}: Setter for promoterIdMapping

\item \code{promoterCoordinates<-}: Setter for promoterCoordinates

\item \code{promoterCoordinates<-,PromoterAnnotation-method}: Setter for promoterCoordinates
}}

\section{Slots}{

\describe{
\item{\code{intronRanges}}{A GRanges object. The intron ranges annotated with the 
promoter information.}

\item{\code{promoterIdMapping}}{A data.frame object. The id mapping between 
transcript ids, names, TSS ids, promoter ids and gene ids.}

\item{\code{promoterCoordinates}}{A GRanges object. Promoter coordinates (TSS) with 
gene id and internal promoter state}
}}

\examples{

promoterAnnotation <- PromoterAnnotation()
intronRanges(promoterAnnotation) <- intronRanges(
                                    promoterAnnotation.gencode.v34.subset)
promoterIdMapping(promoterAnnotation) <- promoterIdMapping(
                                    promoterAnnotation.gencode.v34.subset)
promoterCoordinates(promoterAnnotation) <- promoterCoordinates(
                                    promoterAnnotation.gencode.v34.subset)

}
