% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialMetrics.R
\name{ELSA}
\alias{ELSA}
\title{Calculate ELSA scores}
\usage{
ELSA(labels, location, k = 10)
}
\arguments{
\item{labels}{Cluster labels.}

\item{location}{A numerical matrix containing the location information, with
rows as samples and columns as location dimensions.}

\item{k}{Number of nearest neighbors.}
}
\value{
A dataframe containing the Ea, Ec and ELSA for all samples in the
dataset.
}
\description{
Calculating the Entropy-based Local indicator of Spatial Association (ELSA)
scores, which consist of Ea, Ec and the overall ELSA.
}
\examples{
data(sp_toys)
data <- sp_toys
ELSA(data$label, data[,c("x", "y")], k=6)
ELSA(data$p1, data[,c("x", "y")], k=6)
ELSA(data$p2, data[,c("x", "y")], k=6)
}
\references{
Naimi, Babak, et al., 2019; 10.1016/j.spasta.2018.10.001
}
