% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endo-tile.R
\name{tile_ranges}
\alias{tile_ranges}
\alias{slide_ranges}
\title{Slide or tile over a Ranges object}
\usage{
tile_ranges(x, width)

slide_ranges(x, width, step)
}
\arguments{
\item{x}{a Ranges object}

\item{width}{the maximum width of each window/tile (integer vector of length 1)}

\item{step}{the distance between start position of each sliding window (integer vector of length 1)}
}
\value{
a Ranges object
}
\description{
Slide or tile over a Ranges object
}
\details{
The \code{tile_ranges()} function paritions a Ranges object \code{x} by the given the
\code{width} over all ranges in \code{x}, truncated by the sequence end.
The \code{slide_ranges()} function makes sliding windows within each range of \code{x}
of size \code{width} and sliding by \code{step}.
Both \code{slide_ranges()} and \code{tile_ranges()} return a new Ranges object
with a metadata column called "partition" which contains the index of the
input range \code{x} that a parition belongs to.
}
\examples{
 
gr <- data.frame(seqnames = c("chr1", rep("chr2", 3), rep("chr1", 2), rep("chr3", 4)),
                 start = 1:10,
                 end = 11,
                 strand = c("-", rep("+", 2), rep("*", 2), rep("+", 3), rep("-", 2))) \%>\%
      as_granges() \%>\%
      set_genome_info(seqlengths = c(11,12,13))

# partition ranges into subranges of width 2, odd width ranges
# will have one subrange of width 1              
tile_ranges(gr, width = 2)

# make sliding windows of width 3, moving window with step size of 2
slide_ranges(gr, width = 3, step = 2)

}
\seealso{
\code{GenomicRanges::\link[GenomicRanges:tile-methods]{tile()}}
}
