% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-eval.R
\name{n}
\alias{n}
\title{Compute the number of ranges in each group.}
\usage{
n()
}
\value{
\code{n()} will only be evaluated inside a function call, where it
returns an integer.
}
\description{
This function should only be used
within \code{summarise()}, \code{mutate()} and \code{filter()}.
}
\examples{
ir <- as_iranges(
                 data.frame(start = 1:10,
                            width = 5,
                            name = c(rep("a", 5), rep("b", 3), rep("c", 2))
                            )
                )
by_names <- group_by(ir, name)
summarise(by_names, n = n())
mutate(by_names, n = n())
filter(by_names, n() >= 3)
}
