% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io-bigwig.R
\name{read_bigwig}
\alias{read_bigwig}
\title{Read a BigWig file}
\usage{
read_bigwig(file, genome_info = NULL, overlap_ranges = NULL)
}
\arguments{
\item{file}{A path to a file or URL.}

\item{genome_info}{An optional character string or a Ranges object
that contains information about the genome build. For example the identifier
"hg19" will add build information to the returned GRanges.}

\item{overlap_ranges}{An optional Ranges object. Only the intervals in the file
that overlap the Ranges will be loaded.}
}
\value{
a GRanges object
}
\description{
Read a BigWig file
}
\examples{
if (.Platform$OS.type != "windows") {
  test_path <- system.file("tests", package = "rtracklayer")
  bw_file <- file.path(test_path, "test.bw")
  gr <- read_bigwig(bw_file)
  gr
}
}
\seealso{
\code{rtracklayer::\link[rtracklayer:BigWigFile-class]{BigWigFile()}}
}
