% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-filter.R
\name{filter-ranges}
\alias{filter-ranges}
\alias{filter.Ranges}
\title{Subset a \code{Ranges} object}
\usage{
\method{filter}{Ranges}(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{A \code{Ranges} object}

\item{...}{valid logical predictates to subset .data by. These
are determined by variables in \code{.data}. If more than
one condition is supplied, the conditions are combined with \code{&}. Only
rows where the condition evaluates to \code{TRUE} are kept.}

\item{.preserve}{when FALSE (the default) grouping structure is recalculated, TRUE is currently not implemented.}
}
\value{
a Ranges object
}
\description{
Subset a \code{Ranges} object
}
\details{
For any Ranges objects
\code{filter} can act on all core components of the class including start, end,
width (for IRanges) or seqnames and strand (for GRanges) in addition to
metadata columns. If the Ranges object is grouped, \code{filter} will act
seperately on each  parition of the data.
}
\examples{
set.seed(100)
df <- data.frame(start = 1:10,
                 width = 5,
                 seqnames = "seq1",
                 strand = sample(c("+", "-", "*"), 10, replace = TRUE),
                 gc = runif(10))

rng <- as_granges(df)

filter(rng, strand == "+")
filter(rng, gc > 0.5)

# multiple criteria
filter(rng, strand == "+" | start > 5)
filter(rng, strand == "+" & start > 5)

# multiple conditions are the same as and
filter(rng, strand == "+", start > 5)

# grouping acts on each subset of the data
rng \%>\%
  group_by(strand) \%>\%
  filter(gc > 0.5)

}
\seealso{
\code{\link[dplyr:filter]{dplyr::filter()}}
}
