% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-arithmetic-stretch.R
\name{stretch}
\alias{stretch}
\title{Stretch a genomic interval}
\usage{
stretch(x, extend)
}
\arguments{
\item{x}{a Ranges object, to fix by either the start, end or center
of an interval use \code{anchor_start(x)}, \code{anchor_end(x)},
\code{anchor_center(x)}. To fix by strand use \code{anchor_3p(x)} or
\code{anchor_5p(x)}.}

\item{extend}{the amount to alter the width of a Ranges object by. Either an
integer vector of length 1 or an integer vector the same length as x.}
}
\value{
a Ranges object with modified start or end (or both) coordinates
}
\description{
By default, \code{stretch(x)} will anchor by the center of a Ranges
object. This means that half of the value of \code{extend} will be added to
the end of the range and the remaining half subtracted from the start of
the Range. The other anchors will leave the start/end fixed and stretch
the end/start respectively.
}
\examples{
rng <- as_iranges(data.frame(start=c(2:-1, 13:15), width=c(0:3, 2:0)))
rng2 <- stretch(anchor_center(rng), 10)
stretch(anchor_start(rng2), 10)
stretch(anchor_end(rng2), 10)
grng <- as_granges(data.frame(seqnames = "chr1",
                         strand = c("+", "-", "-", "+", "+", "-", "+"),
                         start=c(2:-1, 13:15),
                         width=c(0:3, 2:0)))
stretch(anchor_3p(grng), 10)
stretch(anchor_5p(grng), 10)
}
\seealso{
\code{anchor()}, \code{mutate()}
}
