% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-overlap-count.R
\name{count_overlaps}
\alias{count_overlaps}
\alias{count_overlaps.IntegerRanges}
\alias{count_overlaps.GenomicRanges}
\alias{count_overlaps_within}
\alias{count_overlaps_within.IntegerRanges}
\alias{count_overlaps_within.GenomicRanges}
\alias{count_overlaps_directed}
\alias{count_overlaps_directed.GenomicRanges}
\alias{count_overlaps_within_directed}
\alias{count_overlaps_within_directed.GenomicRanges}
\title{Count the number of overlaps between two Ranges objects}
\usage{
count_overlaps(x, y, maxgap, minoverlap)

\method{count_overlaps}{IntegerRanges}(x, y, maxgap = -1L, minoverlap = 0L)

\method{count_overlaps}{GenomicRanges}(x, y, maxgap = -1L, minoverlap = 0L)

count_overlaps_within(x, y, maxgap, minoverlap)

\method{count_overlaps_within}{IntegerRanges}(x, y, maxgap = 0L, minoverlap = 1L)

\method{count_overlaps_within}{GenomicRanges}(x, y, maxgap = 0L, minoverlap = 1L)

count_overlaps_directed(x, y, maxgap, minoverlap)

\method{count_overlaps_directed}{GenomicRanges}(x, y, maxgap = -1L, minoverlap = 0L)

count_overlaps_within_directed(x, y, maxgap, minoverlap)

\method{count_overlaps_within_directed}{GenomicRanges}(x, y, maxgap = -1L, minoverlap = 0L)
}
\arguments{
\item{x, y}{Objects representing ranges}

\item{maxgap, minoverlap}{The maximimum gap between intervals as an integer
greater than or equal to zero. The minimum amount of overlap between intervals
as an integer greater than zero, accounting for the maximum gap.}
}
\value{
An integer vector of same length as x.
}
\description{
Count the number of overlaps between two Ranges objects
}
\examples{
query <- data.frame(start = c(5,10, 15,20), width = 5, gc = runif(4)) \%>\%
             as_iranges()
subject <- data.frame(start = 2:6, width = 3:7, label = letters[1:5]) \%>\%
             as_iranges()
query \%>\% mutate(n_olap = count_overlaps(., subject),
                 n_olap_within = count_overlaps_within(., subject))

}
