% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges-bind.R
\name{bind_ranges}
\alias{bind_ranges}
\title{Combine Ranges by concatentating them together}
\usage{
bind_ranges(..., .id = NULL)
}
\arguments{
\item{...}{Ranges objects to combine. Each argument can be a Ranges object,
or a list of Ranges objects.}

\item{.id}{Ranges object identifier. When .id is supplied a new column
is created that links each row to the original Range object. The contents
of the column correspond to the named arguments or the names of the list
supplied.}
}
\value{
a concatenated Ranges object
}
\description{
Combine Ranges by concatentating them together
}
\note{
Currently GRangesList or IRangesList objects are not supported.
}
\examples{
gr <- as_granges(data.frame(start = 10:15,
                            width = 5,
                            seqnames = "seq1"))
gr2 <- as_granges(data.frame(start = 11:14,
                            width = 1:4,
                            seqnames = "seq2"))
bind_ranges(gr, gr2)

bind_ranges(a = gr, b = gr2, .id = "origin")

bind_ranges(gr, list(gr, gr2), gr2)

bind_ranges(list(a = gr, b = gr2), c = gr, .id = "origin")

}
