% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plyranges.R
\docType{package}
\name{plyranges-package}
\alias{plyranges}
\alias{plyranges-package}
\title{plyranges: a grammar of genomic data manipulation}
\description{
plyranges is a dplyr like API to the Ranges/GenomicRanges infrastructure
in Bioconductor.
}
\details{
plryanges provides a consistent interface for importing and
wrangling genomics data from a variety of sources. The package defines a
grammar of genomic data manipulation through a set of verbs. These verbs
can be used to construct human readable analysis pipelines based on Ranges
objects.
\itemize{
\item Modify genomic regions with the \code{set_width()} and \code{stretch()} functions.
\item Modify genomic regions while fixing the start/end/center coordinates
with the \code{anchors()} family of functions.
\item Sort genomic ranges with \code{arrange()}.
\item Modify, subset, and aggregate genomic data with the \code{mutate()},
\code{filter()}, and \code{summarise()}functions.
\item Any of the above operations can be performed on partitions of the
data with \code{group_by()}.
\item Find nearest neighbour genomic regions with the \code{join_nearest()} family
of functions.
\item Find overlaps between ranges with the \code{join_overlap_inner()} family of functions.
\item Merge all overlapping and adjacent genomic regions with \code{reduce_ranges()}.
\item Merge the end points of all genomic regions with \code{disjoin_ranges()}.
\item Import and write common genomic data formats with the \code{read_/write_} family
of functions.
}

For more details on the features of plryanges, read the vignette:
\code{browseVignettes(package = "plyranges")}
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/sa-lee/plyranges}
}

}
\author{
\strong{Maintainer}: Stuart Lee \email{stuart.andrew.lee@gmail.com} (\href{https://orcid.org/0000-0003-1179-8436}{ORCID})

Authors:
\itemize{
  \item Michael Lawrence [contributor]
  \item Dianne Cook [contributor]
}

Other contributors:
\itemize{
  \item Spencer Nystrom (\href{https://orcid.org/0000-0003-1000-1579}{ORCID}) [contributor]
}

}
